/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import java.util.TreeMap;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimePeriodValues;

public class TrendSeries
extends TimePeriodValues {
    private static final long serialVersionUID = -5075886854486506762L;
    private final TreeMap<Double, Integer> minMaxMap = new TreeMap();

    public TrendSeries(String name) {
        super(name);
    }

    public long getMinY() {
        if (!this.minMaxMap.isEmpty()) {
            Double val = this.minMaxMap.firstKey();
            return val.longValue();
        }
        return 0L;
    }

    public long getMaxY() {
        if (!this.minMaxMap.isEmpty()) {
            Double val = this.minMaxMap.lastKey();
            return val.longValue();
        }
        return 0L;
    }

    public void add(TimePeriod tp, double value) {
        super.add(tp, value);
        int counter = 1;
        if (this.minMaxMap.containsKey(value)) {
            counter = this.minMaxMap.get(value);
            ++counter;
        }
        this.minMaxMap.put(value, counter);
    }

    public void delete(int start, int end) {
        if (this.getItemCount() > end && end >= start) {
            for (int i = start; i <= end; ++i) {
                double value = this.getValue(i).doubleValue();
                if (!this.minMaxMap.containsKey(value)) continue;
                int counter = this.minMaxMap.get(value);
                if (--counter > 0) {
                    this.minMaxMap.put(value, counter);
                    continue;
                }
                this.minMaxMap.remove(value);
            }
        }
        super.delete(start, end);
    }
}

