/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.api.configuration.UserSettings;
import com.intel.stl.ui.model.HealthScoreAttribute;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class UserPreference {
    private final Properties properties;

    public UserPreference(UserSettings userSettings) {
        Properties userPrefs = new Properties();
        if (userSettings != null) {
            userPrefs = userSettings.getUserPreference();
        }
        this.properties = userPrefs;
    }

    public UserPreference(Properties userPrefs) {
        this.properties = userPrefs;
    }

    public int getRefreshRate() {
        return this.getInt("RefreshRate");
    }

    public TimeUnit getRefreshRateUnit() {
        String name = "RefreshRateUnits";
        String str = this.properties.getProperty(name);
        if (str != null) {
            return TimeUnit.valueOf(str.toUpperCase());
        }
        throw new IllegalArgumentException("Couldn't find property for '" + name + "'");
    }

    public int getRefreshRateInSeconds() {
        int rate = this.getRefreshRate();
        TimeUnit unit = this.getRefreshRateUnit();
        return (int)TimeUnit.SECONDS.convert(rate, unit);
    }

    public int getTimeWindowInSeconds() {
        return this.getInt("TimingWindow");
    }

    public int getNumWorstNodes() {
        return this.getInt("NumWorstNodes");
    }

    public int getWeightForHealthScoreAttribute(HealthScoreAttribute attribute) {
        int weight = 0;
        String str = this.properties.getProperty(attribute.getPropertiesKey());
        if (str != null) {
            try {
                weight = Integer.valueOf(str);
            }
            catch (NumberFormatException nfe) {
                weight = attribute.getDefaultWeight();
            }
        } else {
            weight = attribute.getDefaultWeight();
        }
        return weight;
    }

    private int getInt(String name) {
        String str = this.properties.getProperty(name);
        if (str != null) {
            try {
                return Integer.valueOf(str);
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
                return -1;
            }
        }
        throw new IllegalArgumentException("Counldn't find property for '" + name + "'");
    }
}

