/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.ui.performance.PmaNoRespGroupSource;
import com.intel.stl.ui.performance.TopoNoRespGroupSource;
import org.jfree.data.time.TimePeriodValues;
import org.jfree.data.time.TimePeriodValuesCollection;

public class UtilDataset
extends TimePeriodValuesCollection {
    private static final long serialVersionUID = 7676929820872719510L;
    private final TimePeriodValuesCollection utilDataset = new TimePeriodValuesCollection();
    private final TimePeriodValuesCollection pmaDataset = new TimePeriodValuesCollection();
    private final TimePeriodValuesCollection topoDataset = new TimePeriodValuesCollection();

    public void addSeries(TimePeriodValues series) {
        super.addSeries(series);
        String name = (String)((Object)series.getKey());
        if (PmaNoRespGroupSource.isPmaNoResp(name)) {
            this.pmaDataset.addSeries(series);
        } else if (TopoNoRespGroupSource.isTopoNoResp(name)) {
            this.topoDataset.addSeries(series);
        } else {
            this.utilDataset.addSeries(series);
        }
    }

    public void removeSeries(TimePeriodValues series) {
        super.removeSeries(series);
        this.pmaDataset.removeSeries(series);
        this.topoDataset.removeSeries(series);
        this.utilDataset.removeSeries(series);
    }

    public TimePeriodValuesCollection getUtilDataset() {
        return this.utilDataset;
    }

    public TimePeriodValuesCollection getPmaDataset() {
        return this.pmaDataset;
    }

    public TimePeriodValuesCollection getTopoDataset() {
        return this.topoDataset;
    }
}

