/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor;

import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.main.view.IChartRangeUpdater;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.Dataset;

public abstract class ChartScaleGroupManager<E extends Dataset> {
    protected Map<JFreeChart, E> chartDataMap = new ConcurrentHashMap<JFreeChart, E>();
    protected long lower;
    protected long upper;
    protected IChartRangeUpdater rangeUpdater = this.getChartRangeUpdater();

    public void addChart(JFreeChart chart, E dataset) {
        this.chartDataMap.put(chart, dataset);
    }

    public void removeChart(JFreeChart chart) {
        this.chartDataMap.remove(chart);
        this.updateChartsRange();
    }

    public void updateChartsRange() {
        this.calculateRangeBounds();
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                for (JFreeChart chart : ChartScaleGroupManager.this.chartDataMap.keySet()) {
                    ChartScaleGroupManager.this.rangeUpdater.updateChartRange(chart, ChartScaleGroupManager.this.lower, ChartScaleGroupManager.this.upper);
                }
            }
        });
    }

    protected void calculateRangeBounds() {
        long lower = Long.MAX_VALUE;
        long upper = Long.MIN_VALUE;
        for (Dataset dataset : this.chartDataMap.values()) {
            long[] minMax = this.getMinMax(dataset);
            lower = Math.min(lower, minMax[0]);
            upper = Math.max(upper, minMax[1]);
        }
        this.lower = lower;
        this.upper = upper;
    }

    abstract IChartRangeUpdater getChartRangeUpdater();

    abstract long[] getMinMax(E var1);
}

