/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor;

import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.model.FlowTypeViz;
import com.intel.stl.ui.model.NodeTypeViz;
import com.intel.stl.ui.monitor.view.PSPortsDetailsPanel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumMap;
import javax.swing.Timer;
import org.jfree.data.general.DefaultPieDataset;

public class PSPortsDetailsController {
    private final String name;
    private final DefaultPieDataset deviceTypeDataset;
    private final DefaultPieDataset flowTypeDataset;
    private final PSPortsDetailsPanel view;
    private final NodeTypeViz[] nodeTypes;
    private final FlowTypeViz[] flowTypes;
    private Timer viewClearTimer;

    public PSPortsDetailsController(String name, PSPortsDetailsPanel view) {
        Enum type;
        int i;
        this.view = view;
        this.name = name;
        view.setName(name);
        this.nodeTypes = view.getNodeTypes();
        this.deviceTypeDataset = new DefaultPieDataset();
        Color[] colors = new Color[this.nodeTypes.length];
        for (i = 0; i < this.nodeTypes.length; ++i) {
            type = this.nodeTypes[i];
            this.deviceTypeDataset.setValue((Comparable)((Object)type), 0.0);
            colors[i] = ((NodeTypeViz)type).getColor();
        }
        view.setDeviceTypeDataset(this.deviceTypeDataset, colors);
        this.flowTypes = view.getFlowTypes();
        this.flowTypeDataset = new DefaultPieDataset();
        colors = new Color[this.flowTypes.length];
        for (i = 0; i < this.flowTypes.length; ++i) {
            type = this.flowTypes[i];
            this.flowTypeDataset.setValue((Comparable)((Object)type), 0.0);
            colors[i] = ((FlowTypeViz)type).getColor();
        }
        view.setFlowTypeDataset(this.flowTypeDataset, colors);
    }

    public PSPortsDetailsPanel getView() {
        return this.view;
    }

    public String getName() {
        return this.name;
    }

    public DefaultPieDataset getTypeDataset() {
        return this.deviceTypeDataset;
    }

    public void setDeviceTypes(long total, EnumMap<NodeType, Long> types) {
        if (this.viewClearTimer != null) {
            if (this.viewClearTimer.isRunning()) {
                this.viewClearTimer.stop();
            }
            this.viewClearTimer = null;
        }
        final long[] counts = NodeTypeViz.getDistributionValues(types);
        final String totalNumber = UIConstants.INTEGER.format(total);
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                PSPortsDetailsController.this.view.setTotalNumber(totalNumber);
                for (NodeTypeViz type : PSPortsDetailsController.this.nodeTypes) {
                    long count = counts[type.ordinal()];
                    PSPortsDetailsController.this.deviceTypeDataset.setValue((Comparable)((Object)type), (double)counts[type.ordinal()]);
                    String number = UIConstants.INTEGER.format(count);
                    String label = count == 1L ? type.getName() : type.getPluralName();
                    PSPortsDetailsController.this.view.setTypeInfo(type, number, label);
                }
            }
        });
    }

    public void setFlowType(final long internalPorts, final long externalPorts) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                PSPortsDetailsController.this.flowTypeDataset.setValue((Comparable)((Object)FlowTypeViz.INTERNAL), (double)internalPorts);
                PSPortsDetailsController.this.flowTypeDataset.setValue((Comparable)((Object)FlowTypeViz.EXTERNAL), (double)externalPorts);
                String text = UIConstants.INTEGER.format(internalPorts);
                PSPortsDetailsController.this.view.setFlowInfo(FlowTypeViz.INTERNAL, text);
                text = UIConstants.INTEGER.format(externalPorts);
                PSPortsDetailsController.this.view.setFlowInfo(FlowTypeViz.EXTERNAL, text);
            }
        });
    }

    public void clear() {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                PSPortsDetailsController.this.deviceTypeDataset.clear();
                PSPortsDetailsController.this.flowTypeDataset.clear();
            }
        });
        this.view.clear();
        if (this.viewClearTimer == null) {
            this.viewClearTimer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PSPortsDetailsController.this.viewClearTimer != null) {
                        PSPortsDetailsController.this.view.clear();
                    }
                }
            });
            this.viewClearTimer.setRepeats(false);
        }
        this.viewClearTimer.restart();
    }
}

