/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor;

import com.intel.stl.api.performance.PortCountersBean;
import com.intel.stl.api.performance.VFPortCountersBean;
import com.intel.stl.ui.common.BaseSectionController;
import com.intel.stl.ui.common.ICardController;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.ObserverAdapter;
import com.intel.stl.ui.common.PinDescription;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.view.ChartsView;
import com.intel.stl.ui.common.view.ISectionListener;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.HelpAction;
import com.intel.stl.ui.main.UndoHandler;
import com.intel.stl.ui.main.view.IDataTypeListener;
import com.intel.stl.ui.model.HistoryType;
import com.intel.stl.ui.monitor.UndoableSectionHistorySelection;
import com.intel.stl.ui.monitor.view.PerformanceChartsSectionView;
import com.intel.stl.ui.performance.PortGroupController;
import com.intel.stl.ui.performance.PortSourceName;
import com.intel.stl.ui.performance.item.RxDataRateItem;
import com.intel.stl.ui.performance.item.RxPktRateItem;
import com.intel.stl.ui.performance.item.TxDataRateItem;
import com.intel.stl.ui.performance.item.TxPktRateItem;
import com.intel.stl.ui.performance.observer.CounterRateObserver;
import com.intel.stl.ui.performance.observer.VFCounterRateObserver;
import com.intel.stl.ui.performance.provider.DataProviderName;
import com.intel.stl.ui.performance.provider.PortCountersProvider;
import com.intel.stl.ui.performance.provider.VFPortCountersProvider;
import net.engio.mbassy.bus.MBassador;

public class PerformanceChartsSection
extends BaseSectionController<ISectionListener, PerformanceChartsSectionView> {
    private final PortGroupController groupController;
    private UndoHandler undoHandler;
    private RxPktRateItem rxPkt;
    private RxDataRateItem rxData;
    private TxPktRateItem txPkt;
    private TxDataRateItem txData;

    public PerformanceChartsSection(PerformanceChartsSectionView view, boolean isNode, MBassador<IAppEvent> eventBus) {
        super(view, eventBus);
        this.createItems();
        this.groupController = new PortGroupController(eventBus, STLConstants.K0200_PERFORMANCE.getValue(), this.rxPkt, this.rxData, this.txPkt, this.txData, HistoryType.values());
        if (this.groupController.getRxCard() != null && this.groupController.getTxCard() != null) {
            view.installCardViews((ChartsView)this.groupController.getRxCard().getView(), (ChartsView)this.groupController.getTxCard().getView());
        }
        this.groupController.setSleepMode(false);
        HelpAction helpAction = HelpAction.getInstance();
        if (isNode) {
            this.setHelpID(helpAction.getNodePerf());
            this.groupController.setHelpIDs(helpAction.getNodeRcvPkts(), helpAction.getNodeTranPkts());
        } else {
            this.setHelpID(helpAction.getPortPerf());
            this.groupController.setHelpIDs(helpAction.getPortRcvPkts(), helpAction.getPortTranPkts());
        }
    }

    private void createItems() {
        PortCountersProvider provider = new PortCountersProvider();
        VFPortCountersProvider vfProvider = new VFPortCountersProvider();
        this.rxPkt = new RxPktRateItem();
        CounterRateObserver rxPktObserver = new CounterRateObserver(this.rxPkt){

            @Override
            protected long getValue(PortCountersBean bean) {
                return bean.getPortRcvPkts();
            }
        };
        this.rxPkt.registerDataProvider(DataProviderName.PORT, provider, rxPktObserver);
        VFCounterRateObserver rxPktVfObserver = new VFCounterRateObserver(this.rxPkt){

            @Override
            protected long getValue(VFPortCountersBean bean) {
                return bean.getPortVFRcvPkts();
            }
        };
        this.rxPkt.registerDataProvider(DataProviderName.VF_PORT, vfProvider, rxPktVfObserver);
        this.rxData = new RxDataRateItem();
        CounterRateObserver rxDataObserver = new CounterRateObserver(this.rxData){

            @Override
            protected long getValue(PortCountersBean bean) {
                return bean.getPortRcvData();
            }
        };
        this.rxData.registerDataProvider(DataProviderName.PORT, provider, rxDataObserver);
        VFCounterRateObserver rxDataVfObserver = new VFCounterRateObserver(this.rxData){

            @Override
            protected long getValue(VFPortCountersBean bean) {
                return bean.getPortVFRcvData();
            }
        };
        this.rxData.registerDataProvider(DataProviderName.VF_PORT, vfProvider, rxDataVfObserver);
        this.txPkt = new TxPktRateItem();
        CounterRateObserver txPktObserver = new CounterRateObserver(this.txPkt){

            @Override
            protected long getValue(PortCountersBean bean) {
                return bean.getPortXmitPkts();
            }
        };
        this.txPkt.registerDataProvider(DataProviderName.PORT, provider, txPktObserver);
        VFCounterRateObserver txPktVfObserver = new VFCounterRateObserver(this.txPkt){

            @Override
            protected long getValue(VFPortCountersBean bean) {
                return bean.getPortVFXmitPkts();
            }
        };
        this.txPkt.registerDataProvider(DataProviderName.VF_PORT, vfProvider, txPktVfObserver);
        this.txData = new TxDataRateItem();
        CounterRateObserver txDataObserver = new CounterRateObserver(this.txData){

            @Override
            protected long getValue(PortCountersBean bean) {
                return bean.getPortXmitData();
            }
        };
        this.txData.registerDataProvider(DataProviderName.PORT, provider, txDataObserver);
        VFCounterRateObserver txDataVfObserver = new VFCounterRateObserver(this.txData){

            @Override
            protected long getValue(VFPortCountersBean bean) {
                return bean.getPortVFXmitData();
            }
        };
        this.txData.registerDataProvider(DataProviderName.VF_PORT, vfProvider, txDataVfObserver);
    }

    public void setPinID(PinDescription.PinID pinID) {
        this.groupController.setPinID(pinID);
    }

    @Override
    public ICardController<?>[] getCards() {
        return this.groupController.getCards().toArray(new ICardController[0]);
    }

    @Override
    protected ISectionListener getSectionListener() {
        return this;
    }

    public void setContext(Context context, IProgressObserver observer) {
        if (observer == null) {
            observer = new ObserverAdapter();
        }
        this.groupController.setContext(context, observer);
        if (context != null && context.getController() != null) {
            this.undoHandler = context.getController().getUndoHandler();
        }
        ((PerformanceChartsSectionView)this.view).setHistoryTypeListener(new IDataTypeListener<HistoryType>(){

            @Override
            public void onDataTypeChange(HistoryType oldType, HistoryType newType) {
                PerformanceChartsSection.this.setHistoryType(newType);
                if (PerformanceChartsSection.this.undoHandler != null && !PerformanceChartsSection.this.undoHandler.isInProgress()) {
                    UndoableSectionHistorySelection sel = new UndoableSectionHistorySelection(PerformanceChartsSection.this, oldType, newType);
                    PerformanceChartsSection.this.undoHandler.addUndoAction(sel);
                }
            }
        });
        observer.onFinish();
    }

    public void onRefresh(IProgressObserver observer) {
        if (observer == null) {
            observer = new ObserverAdapter();
        }
        this.groupController.onRefresh(observer);
        observer.onFinish();
    }

    public void setSource(PortSourceName source) {
        if (source.getVfName() != null) {
            this.groupController.setDataProvider(DataProviderName.VF_PORT);
        } else {
            this.groupController.setDataProvider(DataProviderName.PORT);
        }
        this.groupController.setDataSources(new PortSourceName[]{source});
    }

    public void setHistoryType(HistoryType type) {
        this.groupController.setHistoryType(type);
        ((PerformanceChartsSectionView)this.view).setHistoryType(type);
    }

    public void updateLinkQualityIcon(byte linkQuality) {
        ((PerformanceChartsSectionView)this.view).setLinkQualityValue(linkQuality);
    }
}

