/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor;

import com.intel.stl.ui.common.IPerfSubpageController;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.PageWeight;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.monitor.PerformanceNodeController;
import com.intel.stl.ui.monitor.PerformancePortController;
import com.intel.stl.ui.monitor.PerformanceTreeController;
import com.intel.stl.ui.monitor.TreeNodeType;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.monitor.view.PerformanceSubpageView;
import com.intel.stl.ui.monitor.view.PerformanceView;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import net.engio.mbassy.bus.MBassador;

public class PerformanceSubpageController
implements IPerfSubpageController {
    PerformanceSubpageView subpageView;
    Map<TreeNodeType, IPerfSubpageController> subpages = new HashMap<TreeNodeType, IPerfSubpageController>();
    private PerformancePortController performancePortController;
    private PerformanceNodeController performanceNodeController;
    private final MBassador<IAppEvent> eventBus;
    private PerformanceTreeController parentController;

    public PerformanceSubpageController(PerformanceSubpageView subpageView, MBassador<IAppEvent> eventBus) {
        this.eventBus = eventBus;
        this.subpages = this.getSubPages();
        this.subpageView = subpageView;
        this.subpageView.initializeViews(this.subpages);
    }

    protected Map<TreeNodeType, IPerfSubpageController> getSubPages() {
        this.performancePortController = new PerformancePortController(new PerformanceView(), this.eventBus);
        this.subpages.put(TreeNodeType.ACTIVE_PORT, this.performancePortController);
        this.performanceNodeController = new PerformanceNodeController(new PerformanceView(), this.eventBus);
        this.subpages.put(TreeNodeType.NODE, this.performanceNodeController);
        return this.subpages;
    }

    @Override
    public void setContext(Context context, IProgressObserver observer) {
        IProgressObserver[] subObservers = observer.createSubObservers(2);
        this.performancePortController.setContext(context, subObservers[0]);
        subObservers[0].onFinish();
        this.performanceNodeController.setContext(context, subObservers[1]);
        subObservers[1].onFinish();
    }

    @Override
    public void onRefresh(IProgressObserver observer) {
        IProgressObserver[] subObservers = observer.createSubObservers(2);
        this.performancePortController.onRefresh(subObservers[0]);
        subObservers[0].onFinish();
        this.performanceNodeController.onRefresh(subObservers[1]);
        subObservers[0].onFinish();
    }

    @Override
    public String getName() {
        return STLConstants.K0200_PERFORMANCE.getValue();
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public Component getView() {
        return this.subpageView;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void onEnter() {
    }

    @Override
    public void onExit() {
    }

    @Override
    public boolean canExit() {
        return true;
    }

    @Override
    public void setParentController(PerformanceTreeController parentController) {
        this.parentController = parentController;
    }

    @Override
    public void showNode(FVResourceNode node, IProgressObserver observer) {
        IPerfSubpageController page;
        TreeNodeType nodeType = node.getType();
        this.subpageView.showView(nodeType);
        if (nodeType == TreeNodeType.HFI || nodeType == TreeNodeType.SWITCH) {
            nodeType = TreeNodeType.NODE;
        }
        if ((page = this.subpages.get((Object)nodeType)) == null) {
            throw new IllegalArgumentException("Couldn't find subpage for " + (Object)((Object)nodeType));
        }
        page.showNode(node, observer);
    }

    @Override
    public void clear() {
        this.performancePortController.clear();
        this.performanceNodeController.clear();
    }

    @Override
    public PageWeight getContextSwitchWeight() {
        return PageWeight.MEDIUM;
    }

    @Override
    public PageWeight getRefreshWeight() {
        return PageWeight.MEDIUM;
    }
}

