/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor;

import com.intel.stl.api.configuration.LinkQuality;
import com.intel.stl.api.performance.PortCountersBean;
import com.intel.stl.api.performance.VFPortCountersBean;
import com.intel.stl.ui.common.BaseSectionController;
import com.intel.stl.ui.common.ICardController;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.view.ISectionListener;
import com.intel.stl.ui.common.view.JSectionView;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.HelpAction;
import com.intel.stl.ui.model.PerformanceTableModel;
import com.intel.stl.ui.monitor.PerformanceTableData;
import com.intel.stl.ui.monitor.PortDataAccumulator;
import com.intel.stl.ui.monitor.TableDataDescription;
import com.intel.stl.ui.monitor.view.PerformanceXTableView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.engio.mbassy.bus.MBassador;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceTableSection
extends BaseSectionController<ISectionListener, JSectionView<ISectionListener>> {
    private static final Logger log = LoggerFactory.getLogger(PerformanceTableSection.class);
    private final PerformanceTableModel tableModel;
    private final PerformanceXTableView tableView;
    private PortDataAccumulator portDataAcc;
    private final Map<Short, PortDataAccumulator> portDataAccMap = new HashMap<Short, PortDataAccumulator>();
    private final Map<Short, Long> lastAccessMap = new HashMap<Short, Long>();
    private List<PerformanceTableData> currentDataList = new ArrayList<PerformanceTableData>();

    public PerformanceTableSection(PerformanceTableModel tableModel, PerformanceXTableView tableView, JSectionView<ISectionListener> tableSectionView, MBassador<IAppEvent> eventBus) {
        super(tableSectionView, eventBus);
        this.tableModel = tableModel;
        this.tableView = tableView;
    }

    @Override
    public String getHelpID() {
        return HelpAction.getInstance().getPerfNodePortsTable();
    }

    public void updateTable(PortCountersBean[] beanList, final int previewPortIndex) {
        final ArrayList<PerformanceTableData> dataList = new ArrayList<PerformanceTableData>();
        for (PortCountersBean bean : beanList) {
            PerformanceTableData portData = this.createPortEntry(bean);
            dataList.add(portData);
        }
        this.currentDataList = dataList;
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                int oldSize = PerformanceTableSection.this.tableModel.getEntrySize();
                PerformanceTableSection.this.tableModel.setEntries(dataList);
                if (oldSize == dataList.size()) {
                    PerformanceTableSection.this.tableModel.fireTableRowsUpdated(0, oldSize - 1);
                } else {
                    log.warn("Table changed from " + oldSize + " rows to " + dataList.size() + " rows!!");
                    PerformanceTableSection.this.tableModel.fireTableDataChanged();
                    if (previewPortIndex >= 0 && dataList.size() > 0) {
                        PerformanceTableSection.this.tableView.setSelectedPort(previewPortIndex);
                    }
                }
            }
        });
    }

    public void updateTable(VFPortCountersBean[] beanList, final int previewPortIndex) {
        final ArrayList<PerformanceTableData> data = new ArrayList<PerformanceTableData>();
        for (VFPortCountersBean bean : beanList) {
            PerformanceTableData portData = this.createPortEntry(bean);
            data.add(portData);
        }
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                int oldSize = PerformanceTableSection.this.tableModel.getEntrySize();
                PerformanceTableSection.this.tableModel.setEntries(data);
                if (oldSize == data.size()) {
                    PerformanceTableSection.this.tableModel.fireTableRowsUpdated(0, oldSize - 1);
                } else {
                    log.warn("Table changed from " + oldSize + " rows to " + data.size() + " rows!!");
                    PerformanceTableSection.this.tableModel.fireTableDataChanged();
                    if (previewPortIndex >= 0 && data.size() > 0) {
                        PerformanceTableSection.this.tableView.setSelectedPort(previewPortIndex);
                    }
                }
            }
        });
    }

    public PerformanceTableData createPortEntry(PortCountersBean bean) {
        long rxDataRate = 0L;
        long txDataRate = 0L;
        PerformanceTableData portData = null;
        if (bean == null) {
            log.error(STLConstants.K3047_PORT_BEAN_COUNTERS_NULL.getValue());
            portData = new PerformanceTableData(-1);
            portData.setLinkQuality(LinkQuality.UNKNOWN.getValue());
            return portData;
        }
        portData = new PerformanceTableData(bean.getNodeLid());
        this.portDataAcc = this.portDataAccMap.get(bean.getPortNumber());
        if (this.portDataAcc == null) {
            this.portDataAcc = new PortDataAccumulator();
            this.portDataAccMap.put(bean.getPortNumber(), this.portDataAcc);
        }
        if (this.lastAccessMap.get(bean.getPortNumber()) == null) {
            this.lastAccessMap.put(bean.getPortNumber(), bean.getTimestamp());
        }
        if (bean.hasUnexpectedClear()) {
            this.lastAccessMap.put(bean.getPortNumber(), bean.getTimestamp());
        }
        portData.setPortNumber(bean.getPortNumber());
        portData.setPortRxRemotePhysicalErrors(bean.getPortRcvRemotePhysicalErrors());
        portData.setPortRxDataRate(this.createTableDataDescription(rxDataRate, true));
        portData.setPortTxDataRate(this.createTableDataDescription(txDataRate, true));
        portData.setPortRxSwitchRelayErrors(bean.getPortRcvSwitchRelayErrors());
        portData.setPortTxDiscards(bean.getPortXmitDiscards());
        portData.setExcessiveBufferOverruns(bean.getExcessiveBufferOverruns());
        portData.setFmConfigErrors(bean.getFmConfigErrors());
        portData.setLinkQuality(bean.getLinkQualityIndicator());
        portData.setPortMulticastRcvPkts(bean.getPortMulticastRcvPkts());
        portData.setPortRcvErrors(bean.getPortRcvErrors());
        portData.setPortRcvConstraintErrors(bean.getPortRcvConstraintErrors());
        portData.setPortRcvFECN(bean.getPortRcvFECN());
        portData.setPortRcvBECN(bean.getPortRcvBECN());
        portData.setPortRcvBubble(bean.getPortRcvBubble());
        portData.setPortMulticastXmitPkts(bean.getPortMulticastXmitPkts());
        portData.setPortXmitConstraintErrors(bean.getPortXmitConstraintErrors());
        portData.setPortXmitWait(bean.getPortXmitWait());
        portData.setPortXmitTimeCong(bean.getPortXmitTimeCong());
        portData.setPortXmitWastedBW(bean.getPortXmitWastedBW());
        portData.setPortXmitWaitData(bean.getPortXmitWaitData());
        portData.setLocalLinkIntegrityErrors(bean.getLocalLinkIntegrityErrors());
        portData.setPortMarkFECN(bean.getPortMarkFECN());
        portData.setLinkErrorRecovery(bean.getLinkErrorRecovery());
        portData.setLinkDowned(bean.getLinkDowned());
        portData.setNumLanesDown(bean.getNumLanesDown());
        portData.setUncorrectableErrors(bean.getUncorrectableErrors());
        portData.setSwPortCongestion(bean.getSwPortCongestion());
        if (bean.isDelta()) {
            throw new IllegalArgumentException("We do not support delta style PortCounters");
        }
        long rxPackets = bean.getPortRcvPkts();
        long rxData = bean.getPortRcvData();
        long txPackets = bean.getPortXmitPkts();
        long txData = bean.getPortXmitData();
        if (bean.getTimestamp() > this.lastAccessMap.get(bean.getPortNumber())) {
            long deltaTime = bean.getTimestamp() - this.lastAccessMap.get(bean.getPortNumber());
            portData.setPortRxPktsRate((rxPackets - this.portDataAcc.getRxCumulativePacket()) / deltaTime);
            portData.setPortRxDataRate(this.createTableDataDescription((rxData - this.portDataAcc.getRxCumulativeData()) / deltaTime, true));
            portData.setPortTxPktsRate((txPackets - this.portDataAcc.getTxCumulativePacket()) / deltaTime);
            portData.setPortTxDataRate(this.createTableDataDescription((txData - this.portDataAcc.getTxCumulativeData()) / deltaTime, true));
        }
        portData.setPortRxCumulativePkts(rxPackets);
        portData.setPortRxCumulativeData(this.createTableDataDescription(rxData, false));
        portData.setPortTxCumulativePkts(txPackets);
        portData.setPortTxCumulativeData(this.createTableDataDescription(txData, false));
        this.portDataAcc.setRxCumulativePacket(rxPackets);
        this.portDataAcc.setRxCumulativeData(rxData);
        this.portDataAcc.setTxCumulativePacket(txPackets);
        this.portDataAcc.setTxCumulativeData(txData);
        this.lastAccessMap.put(bean.getPortNumber(), bean.getTimestamp());
        this.portDataAccMap.put(bean.getPortNumber(), this.portDataAcc);
        return portData;
    }

    public PerformanceTableData createPortEntry(VFPortCountersBean bean) {
        long rxDataRate = 0L;
        long txDataRate = 0L;
        PerformanceTableData portData = null;
        if (bean == null) {
            log.error(STLConstants.K3047_PORT_BEAN_COUNTERS_NULL.getValue());
            portData = new PerformanceTableData(-1);
            portData.setLinkQuality(LinkQuality.UNKNOWN.getValue());
            return portData;
        }
        portData = new PerformanceTableData(bean.getNodeLid());
        this.portDataAcc = this.portDataAccMap.get(bean.getPortNumber());
        if (this.portDataAcc == null) {
            this.portDataAcc = new PortDataAccumulator();
            this.portDataAccMap.put(bean.getPortNumber(), this.portDataAcc);
        }
        if (this.lastAccessMap.get(bean.getPortNumber()) == null) {
            this.lastAccessMap.put(bean.getPortNumber(), bean.getTimestamp());
        }
        if (bean.hasUnexpectedClear()) {
            this.lastAccessMap.put(bean.getPortNumber(), bean.getTimestamp());
        }
        portData.setPortNumber(bean.getPortNumber());
        portData.setPortRxRemotePhysicalErrors(-1L);
        portData.setPortRxDataRate(this.createTableDataDescription(rxDataRate, true));
        portData.setPortTxDataRate(this.createTableDataDescription(txDataRate, true));
        portData.setPortRxSwitchRelayErrors(-1L);
        portData.setPortTxDiscards(bean.getPortVFXmitDiscards());
        portData.setExcessiveBufferOverruns(-1L);
        portData.setFmConfigErrors(-1L);
        portData.setPortMulticastRcvPkts(-1L);
        portData.setPortRcvErrors(-1L);
        portData.setPortRcvConstraintErrors(-1L);
        portData.setPortRcvFECN(bean.getPortVFRcvFECN());
        portData.setPortRcvBECN(bean.getPortVFRcvBECN());
        portData.setPortRcvBubble(bean.getPortVFRcvBubble());
        portData.setPortMulticastXmitPkts(-1L);
        portData.setPortXmitConstraintErrors(-1L);
        portData.setPortXmitWait(bean.getPortVFXmitWait());
        portData.setPortXmitTimeCong(bean.getPortVFXmitTimeCong());
        portData.setPortXmitWastedBW(bean.getPortVFXmitWastedBW());
        portData.setPortXmitWaitData(bean.getPortVFXmitWaitData());
        portData.setLocalLinkIntegrityErrors(-1L);
        portData.setPortMarkFECN(bean.getPortVFMarkFECN());
        portData.setLinkErrorRecovery(-1L);
        portData.setLinkDowned(-1L);
        portData.setNumLanesDown((byte)-1);
        portData.setUncorrectableErrors((short)-1);
        portData.setSwPortCongestion(bean.getSwPortVFCongestion());
        if (bean.isDelta()) {
            throw new IllegalArgumentException("We do not support delta style PortCounters");
        }
        long rxPackets = bean.getPortVFRcvPkts();
        long rxData = bean.getPortVFRcvData();
        long txPackets = bean.getPortVFXmitPkts();
        long txData = bean.getPortVFXmitData();
        if (bean.getTimestamp() > this.lastAccessMap.get(bean.getPortNumber())) {
            long deltaTime = bean.getTimestamp() - this.lastAccessMap.get(bean.getPortNumber());
            portData.setPortRxPktsRate((rxPackets - this.portDataAcc.getRxCumulativePacket()) / deltaTime);
            portData.setPortRxDataRate(this.createTableDataDescription((rxData - this.portDataAcc.getRxCumulativeData()) / deltaTime, true));
            portData.setPortTxPktsRate((txPackets - this.portDataAcc.getTxCumulativePacket()) / deltaTime);
            portData.setPortTxDataRate(this.createTableDataDescription((txData - this.portDataAcc.getTxCumulativeData()) / deltaTime, true));
        }
        portData.setPortRxCumulativePkts(rxPackets);
        portData.setPortRxCumulativeData(this.createTableDataDescription(rxData, false));
        portData.setPortTxCumulativePkts(txPackets);
        portData.setPortTxCumulativeData(this.createTableDataDescription(txData, false));
        this.portDataAcc.setRxCumulativePacket(rxPackets);
        this.portDataAcc.setRxCumulativeData(rxData);
        this.portDataAcc.setTxCumulativePacket(txPackets);
        this.portDataAcc.setTxCumulativeData(txData);
        this.lastAccessMap.put(bean.getPortNumber(), bean.getTimestamp());
        this.portDataAccMap.put(bean.getPortNumber(), this.portDataAcc);
        return portData;
    }

    private TableDataDescription createTableDataDescription(double data, boolean isRate) {
        double dataBytes = data * 8.0;
        String dataFlits = null;
        dataFlits = isRate ? Double.toString(data) + " " + STLConstants.K3222_FPS.getValue() : Long.toString((long)data) + " " + STLConstants.K0748_FLITS.getValue();
        return new TableDataDescription(dataBytes, dataFlits);
    }

    public List<PerformanceTableData> getCurrentDataList() {
        return this.currentDataList;
    }

    @Override
    public void clear() {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                PerformanceTableSection.this.portDataAccMap.clear();
                PerformanceTableSection.this.lastAccessMap.clear();
            }
        });
    }

    @Override
    public ICardController<?>[] getCards() {
        return null;
    }

    @Override
    protected ISectionListener getSectionListener() {
        return this;
    }

    public PerformanceXTableView getTableView() {
        return this.tableView;
    }
}

