/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor;

import com.intel.stl.ui.common.FinishObserver;
import com.intel.stl.ui.common.IContextAware;
import com.intel.stl.ui.common.IPerfSubpageController;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.configuration.DevicePropertiesController;
import com.intel.stl.ui.configuration.view.DevicePropertiesPanel;
import com.intel.stl.ui.event.JumpDestination;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.UndoableSelection;
import com.intel.stl.ui.main.view.IPageListener;
import com.intel.stl.ui.model.ConnectivityTableModel;
import com.intel.stl.ui.model.DeviceProperties;
import com.intel.stl.ui.monitor.ConnectivitySubpageController;
import com.intel.stl.ui.monitor.PSSubpageController;
import com.intel.stl.ui.monitor.PerformanceSubpageController;
import com.intel.stl.ui.monitor.SearchController;
import com.intel.stl.ui.monitor.TreeController;
import com.intel.stl.ui.monitor.TreeNodeType;
import com.intel.stl.ui.monitor.TreeSelection;
import com.intel.stl.ui.monitor.TreeSubpageSelection;
import com.intel.stl.ui.monitor.UndoablePerfTreeSelection;
import com.intel.stl.ui.monitor.UndoableSubpageSelection;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.monitor.tree.FVTreeManager;
import com.intel.stl.ui.monitor.tree.FVTreeModel;
import com.intel.stl.ui.monitor.view.ConnectivitySubpageView;
import com.intel.stl.ui.monitor.view.PerformanceSubpageView;
import com.intel.stl.ui.monitor.view.PerformanceTreeView;
import com.intel.stl.ui.monitor.view.SummarySubpageView;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import javax.swing.tree.TreePath;
import net.engio.mbassy.bus.MBassador;

public class PerformanceTreeController
extends TreeController<PerformanceTreeView>
implements IPageListener {
    private List<IPerfSubpageController> mSubpages;
    private String previousSubpageName;
    private String currentSubpageName;
    private IPerfSubpageController currentSubpage;
    private EnumMap<TreeNodeType, List<IPerfSubpageController>> pageMap;
    private FVResourceNode lastNode;

    public PerformanceTreeController(PerformanceTreeView pTreeView, MBassador<IAppEvent> eventBus, FVTreeManager treeBuilder) {
        super(pTreeView, eventBus, treeBuilder);
        ((PerformanceTreeView)this.view).setPageListener(this);
        ((PerformanceTreeView)this.view).setSelectionMode(1);
        this.initSubpages();
        new SearchController(((PerformanceTreeView)this.view).getSearchView(), eventBus, treeBuilder, this);
    }

    @Override
    protected synchronized void showNode(FVResourceNode node) {
        if (node == null) {
            return;
        }
        ((PerformanceTreeView)this.view).setNodeName(node);
        this.setRunning(true);
        if (this.lastNode != null) {
            if (this.lastNode.hasSamePath(node) && this.lastNode.getRoot() == node.getRoot()) {
                this.currentSubpage.showNode(node, new FinishObserver(){

                    @Override
                    public void onFinish() {
                        PerformanceTreeController.this.setRunning(false);
                    }
                });
                return;
            }
            this.collapseTreeSelection(this.lastNode, node);
        }
        for (IPerfSubpageController page : this.mSubpages) {
            page.clear();
        }
        List<IPerfSubpageController> subpages = this.getSubpagesByType(node.getType());
        if (subpages == null) {
            ((PerformanceTreeView)this.view).clearPage(node.getType());
            this.setRunning(false);
            this.lastNode = null;
        } else {
            this.previousSubpageName = this.currentSubpageName;
            int curIndex = -1;
            IPerfSubpageController subpage = null;
            if (this.currentSubpageName != null) {
                for (int i = 0; i < subpages.size(); ++i) {
                    subpage = subpages.get(i);
                    if (!subpage.getName().equals(this.currentSubpageName)) continue;
                    curIndex = i;
                    break;
                }
            }
            if (curIndex == -1) {
                curIndex = 0;
                subpage = subpages.get(0);
                this.currentSubpageName = subpage.getName();
            }
            subpage.showNode(node, new FinishObserver(){

                @Override
                public void onFinish() {
                    PerformanceTreeController.this.setRunning(false);
                }
            });
            this.lastNode = node;
            this.currentSubpage = subpage;
            ((PerformanceTreeView)this.view).setTabs(subpages, curIndex);
        }
    }

    protected void collapseTreeSelection(FVResourceNode node, FVResourceNode current) {
        TreePath toCollapse = null;
        switch (node.getType()) {
            case SWITCH: 
            case HFI: 
            case ACTIVE_PORT: 
            case INACTIVE_PORT: {
                if (node.getParent() == null) break;
                toCollapse = node.getParent().getPath();
                break;
            }
        }
        FVResourceNode parent = current.getParent();
        switch (current.getType()) {
            case SWITCH: 
            case HFI: {
                if (parent == null || !parent.getPath().equals(toCollapse)) break;
                toCollapse = null;
                break;
            }
            case ACTIVE_PORT: 
            case INACTIVE_PORT: {
                if (parent == null) break;
                if (parent.getPath().equals(toCollapse)) {
                    toCollapse = null;
                }
                if ((parent = parent.getParent()) == null || !parent.getPath().equals(toCollapse)) break;
                toCollapse = null;
                break;
            }
        }
        if (toCollapse != null) {
            ((PerformanceTreeView)this.view).collapseTreePath(this.getCurrentTreeModel(), toCollapse);
            ((PerformanceTreeView)this.view).ensureSelectionVisible(this.getCurrentTreeModel());
        }
    }

    @Override
    protected void showNodes(FVResourceNode[] node) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected UndoableSelection<?> getUndoableSelection(TreeSelection oldSelection, TreeSelection newSelection) {
        TreeSubpageSelection oldTSSelection = new TreeSubpageSelection(oldSelection, this.previousSubpageName);
        TreeSubpageSelection newTSSelection = new TreeSubpageSelection(newSelection, null);
        return new UndoablePerfTreeSelection(this, oldTSSelection, newTSSelection);
    }

    @Override
    protected FVResourceNode getCurrentNode() {
        return this.lastNode;
    }

    protected void initSubpages() {
        PerformanceSubpageView perfSubpageView = new PerformanceSubpageView();
        SummarySubpageView summarySubpageView = new SummarySubpageView();
        ConnectivityTableModel connectTableModel = new ConnectivityTableModel();
        ConnectivitySubpageView connectSubpageView = new ConnectivitySubpageView(connectTableModel);
        DevicePropertiesPanel propSubpageView = new DevicePropertiesPanel();
        PSSubpageController summarySP = new PSSubpageController(summarySubpageView, (MBassador<IAppEvent>)this.eventBus);
        summarySP.setParentController(this);
        PerformanceSubpageController performanceSP = new PerformanceSubpageController(perfSubpageView, (MBassador<IAppEvent>)this.eventBus);
        performanceSP.setParentController(this);
        ConnectivitySubpageController connectSP = new ConnectivitySubpageController(connectTableModel, connectSubpageView, (MBassador<IAppEvent>)this.eventBus);
        connectSP.setParentController(this);
        DeviceProperties props = new DeviceProperties();
        DevicePropertiesController propertySP = new DevicePropertiesController(props, propSubpageView, (MBassador<IAppEvent>)this.eventBus);
        propertySP.setParentController(this);
        this.mSubpages = Arrays.asList(summarySP, performanceSP, connectSP, propertySP);
        this.pageMap = new EnumMap(TreeNodeType.class);
        this.pageMap.put(TreeNodeType.ALL, Arrays.asList(summarySP));
        this.pageMap.put(TreeNodeType.INACTIVE_PORT, null);
        this.pageMap.put(TreeNodeType.DEVICE_GROUP, Arrays.asList(summarySP));
        this.pageMap.put(TreeNodeType.HCA_GROUP, Arrays.asList(summarySP));
        this.pageMap.put(TreeNodeType.ROUTER_GROUP, Arrays.asList(summarySP));
        this.pageMap.put(TreeNodeType.SWITCH_GROUP, Arrays.asList(summarySP));
        this.pageMap.put(TreeNodeType.VIRTUAL_FABRIC, Arrays.asList(summarySP));
        this.pageMap.put(TreeNodeType.HFI, Arrays.asList(performanceSP, connectSP, propertySP));
        this.pageMap.put(TreeNodeType.SWITCH, Arrays.asList(performanceSP, connectSP, propertySP));
        this.pageMap.put(TreeNodeType.ACTIVE_PORT, Arrays.asList(performanceSP, connectSP, propertySP));
    }

    @Override
    public void setContext(Context pContext, IProgressObserver observer) {
        int i;
        IProgressObserver[] subObservers = observer.createSubObservers(this.mSubpages.size() + 1);
        for (i = 0; i < this.mSubpages.size(); ++i) {
            this.mSubpages.get(i).setContext(pContext, subObservers[i]);
            subObservers[i].onFinish();
            if (!observer.isCancelled()) continue;
            for (int j = 0; j <= i; ++j) {
                this.mSubpages.get(j).clear();
            }
            return;
        }
        super.setContext(pContext, subObservers[this.mSubpages.size()]);
        if (observer.isCancelled()) {
            for (i = 0; i < this.mSubpages.size(); ++i) {
                for (int j = 0; j <= i; ++j) {
                    this.mSubpages.get(j).clear();
                }
            }
        }
    }

    public void setRunning(boolean isRunning) {
        ((PerformanceTreeView)this.view).setRunning(isRunning);
    }

    protected List<IPerfSubpageController> getSubpagesByType(TreeNodeType type) {
        return this.pageMap.get((Object)type);
    }

    @Override
    public boolean canPageChange(String oldPage, String newPage) {
        return true;
    }

    @Override
    public synchronized void onPageChanged(String oldPageId, String newPageId) {
        List<IPerfSubpageController> subpages = this.getSubpagesByType(this.lastNode.getType());
        if (subpages == null) {
            throw new RuntimeException("No pages found for last node " + this.lastNode);
        }
        IPerfSubpageController oldPage = null;
        for (IPerfSubpageController page : subpages) {
            if (!page.getName().equals(oldPageId)) continue;
            oldPage = page;
            oldPage.onExit();
            break;
        }
        IContextAware newPage = null;
        for (IPerfSubpageController page : subpages) {
            if (!page.getName().equals(newPageId)) continue;
            newPage = page;
            break;
        }
        if (newPage != null && !this.currentSubpageName.equals(newPage.getName())) {
            this.setRunning(true);
            newPage.onEnter();
            newPage.showNode(this.lastNode, new FinishObserver(){

                @Override
                public void onFinish() {
                    PerformanceTreeController.this.setRunning(false);
                }
            });
            this.currentSubpageName = newPage.getName();
            this.currentSubpage = newPage;
        }
        if (this.undoHandler != null && !this.undoHandler.isInProgress()) {
            UndoableSubpageSelection undoSel = new UndoableSubpageSelection((PerformanceTreeView)this.view, oldPageId, newPageId);
            this.undoHandler.addUndoAction(undoSel);
        }
    }

    @Override
    public String getName() {
        return JumpDestination.PERFORMANCE.getName();
    }

    public void showNode(FVTreeModel treeModel, TreePath[] paths, boolean[] expanded, String subpageName) {
        this.currentSubpageName = subpageName;
        this.showNode(treeModel, paths, expanded);
    }
}

