/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor;

import com.intel.stl.ui.common.ICancelIndicator;
import com.intel.stl.ui.common.TimeDrivenProgressObserver;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.monitor.ISearchListener;
import com.intel.stl.ui.monitor.TreeController;
import com.intel.stl.ui.monitor.TreeSearchType;
import com.intel.stl.ui.monitor.TreeTypeEnum;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.monitor.tree.FVTreeManager;
import com.intel.stl.ui.monitor.tree.FVTreeModel;
import com.intel.stl.ui.monitor.tree.SearchResult;
import com.intel.stl.ui.monitor.tree.SearchResultNode;
import com.intel.stl.ui.monitor.view.SearchView;
import com.intel.stl.ui.publisher.CancellableCall;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import net.engio.mbassy.bus.MBassador;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchController
implements TreeSelectionListener,
ISearchListener,
PropertyChangeListener {
    private static final Logger log = LoggerFactory.getLogger(SearchController.class);
    private final SearchView searchView;
    private final FVTreeManager treeSearcher;
    private TreeSearchType searchType;
    private String searchValue;
    private final TreeController<?> parentTreeController;
    private EnumMap<TreeTypeEnum, SearchResult> resultTrees;
    private TreeTypeEnum treeType;
    private int treeNodeCount;
    private int totalNodeCount;
    private FVTreeModel treeModel;
    private final EnumMap<TreeTypeEnum, SearchResult> searchResultsMap;
    private SwingWorker<EnumMap<TreeTypeEnum, SearchResult>, SearchResult> worker;
    private PropertyChangeSupport support;
    private TimeDrivenProgressObserver observer;
    public static final String PROGRESS_AMOUNT_PROPERTY = "ProgressAmount";
    public static final String PROGRESS_NOTE_PROPERTY = "ProgressNote";
    private double workDone;
    private ICancelIndicator cancelIndicator;

    public SearchController(SearchView pTreeView, MBassador<IAppEvent> eventBus, FVTreeManager treeBuilder, TreeController<?> parentTreeController) {
        this.treeSearcher = treeBuilder;
        this.searchView = pTreeView;
        this.searchView.addSearchListener(this);
        this.searchView.addTreeSelectionListener(this);
        this.searchView.setSelectionMode(1);
        this.parentTreeController = parentTreeController;
        this.searchResultsMap = new EnumMap(TreeTypeEnum.class);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        SearchResultNode resultNode;
        Object node;
        JTree tree = (JTree)e.getSource();
        if (tree.getSelectionCount() == 1 && (node = tree.getLastSelectedPathComponent()) != null && node instanceof SearchResultNode && (resultNode = (SearchResultNode)node).isNode()) {
            SearchResult searchResult;
            TreeTypeEnum treeType = this.findTreeType(resultNode);
            FVResourceNode matchingNode = null;
            if (this.resultTrees != null && resultNode != null && (searchResult = this.resultTrees.get((Object)treeType)) != null) {
                matchingNode = searchResult.getNodeMap().get(resultNode);
            }
            if (matchingNode != null) {
                this.parentTreeController.showNode(treeType, matchingNode);
            }
        }
    }

    private TreeTypeEnum findTreeType(FVResourceNode node) {
        TreeTypeEnum res = null;
        while (node != null && (res = this.getTreeType(node)) == null) {
            node = node.getParent();
        }
        return res;
    }

    private TreeTypeEnum getTreeType(FVResourceNode node) {
        switch (node.getType()) {
            case DEVICE_GROUP: {
                return TreeTypeEnum.DEVICE_GROUPS_TREE;
            }
            case VIRTUAL_FABRIC: {
                return TreeTypeEnum.VIRTUAL_FABRICS_TREE;
            }
            case HCA_GROUP: 
            case SWITCH_GROUP: 
            case ROUTER_GROUP: {
                return TreeTypeEnum.DEVICE_TYPES_TREE;
            }
        }
        return null;
    }

    @Override
    public void setSearchType(TreeSearchType type) {
        this.searchType = type;
    }

    @Override
    public void setSearchValue(String value) {
        this.searchValue = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void searchTree() {
        this.resultTrees = null;
        this.workDone = 0.0;
        this.totalNodeCount = 0;
        SearchController searchController = this;
        synchronized (searchController) {
            if (this.worker != null && !this.worker.isDone()) {
                this.worker.removePropertyChangeListener(this);
                this.worker.cancel(true);
            }
        }
        final CancellableCall<SearchResult> caller = new CancellableCall<SearchResult>(){

            @Override
            public SearchResult call(ICancelIndicator cancelIndicator) throws Exception {
                SearchResult result = SearchController.this.treeSearcher.searchTreeNode(SearchController.this.treeType, SearchController.this.searchType, SearchController.this.searchValue, SearchController.this.observer, cancelIndicator);
                return result;
            }
        };
        this.worker = new SwingWorker<EnumMap<TreeTypeEnum, SearchResult>, SearchResult>(){

            @Override
            protected EnumMap<TreeTypeEnum, SearchResult> doInBackground() throws Exception {
                if (this.isCancelled()) {
                    log.info("Cancelled search tree ");
                    return null;
                }
                for (FVTreeManager.TreeManagementModel model : SearchController.this.treeSearcher.getMgrModels().values()) {
                    if (model.getTree() == null) continue;
                    SearchController.this.totalNodeCount += SearchController.this.getNodeCount(model.getTree());
                }
                if (SearchController.this.totalNodeCount > 0) {
                    SearchController.this.observer = new TimeDrivenProgressObserver(this.getPropertyChangeSupport(), SearchController.this.totalNodeCount);
                    SearchController.this.searchResultsMap.clear();
                    for (TreeTypeEnum type : TreeTypeEnum.values()) {
                        SearchController.this.treeType = type;
                        SearchResult result = (SearchResult)caller.call();
                        if (result == null) continue;
                        SearchController.this.searchResultsMap.put(SearchController.this.treeType, result);
                        this.publish(result);
                    }
                }
                return SearchController.this.searchResultsMap;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    SearchController.this.resultTrees = (EnumMap)this.get();
                    if (SearchController.this.resultTrees == null) {
                        if (caller.getCancelIndicator().isCancelled()) {
                            SearchController.this.searchView.showMessage(UILabels.STL50203_SEARCH_CANCELLED.getDescription());
                        } else {
                            SearchController.this.searchView.showMessage(UILabels.STL50204_SEARCH_NULL.getDescription());
                        }
                    } else if (SearchController.this.resultTrees.isEmpty()) {
                        SearchController.this.searchView.showMessage(UILabels.STL50205_SEARCH_EMPTY.getDescription());
                    } else {
                        SearchController.this.buildTree(SearchController.this.resultTrees);
                        SearchController.this.searchView.showTree(true);
                    }
                }
                catch (InterruptedException e) {
                }
                catch (CancellationException e) {
                    SearchController.this.searchView.showMessage(UILabels.STL50203_SEARCH_CANCELLED.getDescription());
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException e) {}
                    SearchController.this.searchView.enableSearch();
                }
            }

            @Override
            protected void process(List<SearchResult> results) {
                for (SearchResult result : results) {
                    SearchController.this.observer.publishNote(result.getTreeType().getName() + " " + result.getResultTree().getNumHits());
                }
            }
        };
        this.cancelIndicator = caller.getCancelIndicator();
        caller.setCancelIndicator(new ICancelIndicator(){

            @Override
            public boolean isCancelled() {
                return SearchController.this.worker.isCancelled() || SearchController.this.cancelIndicator != null && SearchController.this.cancelIndicator.isCancelled();
            }
        });
        this.worker.addPropertyChangeListener(this);
        this.support = this.worker.getPropertyChangeSupport();
        this.searchView.setRunning(true);
        this.worker.execute();
    }

    public int getNodeCount(FVResourceNode root) {
        if (root.isNode()) {
            this.treeNodeCount = 1;
        } else {
            this.treeNodeCount = 0;
            for (FVResourceNode child : root.getChildren()) {
                this.treeNodeCount += this.getNodeCount(child);
            }
        }
        return this.treeNodeCount;
    }

    protected void buildTree(EnumMap<TreeTypeEnum, SearchResult> resultTrees) {
        for (Map.Entry<TreeTypeEnum, SearchResult> entry : resultTrees.entrySet()) {
            SearchResultNode root = entry.getValue().getResultTree();
            if (root == null) continue;
            this.treeModel = new FVTreeModel(root);
            this.searchView.setTreeModel(entry.getKey(), this.treeModel, root.getNumHits());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (PROGRESS_AMOUNT_PROPERTY == evt.getPropertyName()) {
            double progress = (Double)evt.getNewValue();
            this.workDone += progress;
            double percentProgress = this.workDone / (double)this.totalNodeCount * 100.0;
            if (percentProgress > 100.0) {
                percentProgress = 100.0;
            }
            if (this.searchView != null) {
                this.searchView.setProgress((int)percentProgress);
            }
        } else if (PROGRESS_NOTE_PROPERTY == evt.getPropertyName()) {
            String note = (String)evt.getNewValue();
            if (this.searchView != null) {
                this.searchView.setProgressNote(note);
            }
        }
    }

    @Override
    public void cancel() {
        this.worker.cancel(true);
    }
}

