/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor;

import com.intel.stl.api.configuration.ResourceType;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.ui.common.UIImages;
import javax.swing.ImageIcon;

public enum TreeNodeType {
    ALL(UIImages.SUBNET_ICON),
    HCA_GROUP(UIImages.HFI_GROUP_ICON),
    SWITCH_GROUP(UIImages.SW_GROUP_ICON),
    ROUTER_GROUP(null),
    DEVICE_GROUP(UIImages.DEVICE_GROUP_ICON),
    VIRTUAL_FABRIC(UIImages.VIRTUAL_FABRIC_ICON),
    NODE(null),
    HFI(UIImages.HFI_ICON),
    SWITCH(UIImages.SW_ICON),
    ROUTER(null),
    PORT(null),
    ACTIVE_PORT(UIImages.PORT_ICON),
    INACTIVE_PORT(UIImages.INACTIVE_PORT_ICON),
    SYSTEM_IMAGE(UIImages.SYS_IMG);

    private final UIImages icon;

    private TreeNodeType(UIImages icon) {
        this.icon = icon;
    }

    public ImageIcon getIcon() {
        return this.icon.getImageIcon();
    }

    public static ResourceType getResourceTypeFor(TreeNodeType nodeType) {
        ResourceType resourceType;
        switch (nodeType) {
            case HFI: {
                resourceType = ResourceType.HFI;
                break;
            }
            case SWITCH: {
                resourceType = ResourceType.SWITCH;
                break;
            }
            case PORT: {
                resourceType = ResourceType.PORT;
                break;
            }
            case ACTIVE_PORT: {
                resourceType = ResourceType.PORT;
                break;
            }
            default: {
                resourceType = null;
            }
        }
        return resourceType;
    }

    public static NodeType getNodeType(TreeNodeType type) {
        switch (type) {
            case HFI: {
                return NodeType.HFI;
            }
            case SWITCH: {
                return NodeType.SWITCH;
            }
            case ROUTER: {
                return NodeType.ROUTER;
            }
        }
        return null;
    }

    public static byte getNodeTypeCode(TreeNodeType type) {
        switch (type) {
            case HFI: {
                return NodeType.HFI.getId();
            }
            case SWITCH: {
                return NodeType.SWITCH.getId();
            }
            case ROUTER: {
                return NodeType.ROUTER.getId();
            }
        }
        return NodeType.UNKNOWN.getId();
    }
}

