/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor.tree;

import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.monitor.tree.ITreeMonitor;
import com.intel.stl.ui.monitor.tree.TreeNodeFactory;
import com.intel.stl.ui.monitor.tree.TreeSynchronizer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyBasedNodesSynchronizer
extends TreeSynchronizer<Long> {
    private static final Logger log = LoggerFactory.getLogger(CopyBasedNodesSynchronizer.class);
    private final Map<Long, FVResourceNode> nodeMap;

    public CopyBasedNodesSynchronizer(Map<Long, FVResourceNode> nodeMap) {
        super(false);
        this.nodeMap = nodeMap;
    }

    @Override
    protected int compare(FVResourceNode node, Long element) {
        int res = Long.compare(node.getGuid(), element);
        if (res != 0) {
            String name1 = node.getName();
            FVResourceNode node2 = this.nodeMap.get(element);
            String name2 = node2 == null ? null : node2.getName();
            res = TreeNodeFactory.comapreNodeName(name1, name2);
        }
        return res;
    }

    @Override
    protected FVResourceNode createNode(Long key) {
        FVResourceNode node = this.nodeMap.get(key);
        return node == null ? new FVResourceNode("null", null, -1) : node.copy();
    }

    @Override
    protected void updateNode(FVResourceNode node, FVResourceNode parent, List<ITreeMonitor> monitors, IProgressObserver observer) {
        FVResourceNode port;
        int i;
        FVResourceNode refNode = this.nodeMap.get(node.getGuid());
        if (refNode == null) {
            throw new IllegalArgumentException("Couldn't find FVResourceNode " + node.getId() + ":" + node.getGuid());
        }
        HashMap<Integer, FVResourceNode> updated = new HashMap<Integer, FVResourceNode>();
        boolean hasStructureChange = false;
        int toUpdate = Math.min(refNode.getChildCount(), node.getChildCount());
        for (i = 0; i < toUpdate; ++i) {
            boolean hasChanged;
            port = node.getChildAt(i);
            FVResourceNode refPort = refNode.getChildAt(i);
            if (port.getType() == refPort.getType()) continue;
            boolean bl = hasChanged = port.getType() != refPort.getType();
            if (!hasChanged) continue;
            port.setType(refPort.getType());
            updated.put(i, port);
        }
        if (toUpdate < node.getChildCount()) {
            for (i = toUpdate; i < node.getChildCount(); ++i) {
                node.removeChild(toUpdate);
                if (hasStructureChange) continue;
                hasStructureChange = true;
            }
        } else if (toUpdate < refNode.getChildCount()) {
            for (i = toUpdate; i < refNode.getChildCount(); ++i) {
                port = refNode.getChildAt(i).copy();
                node.addChild(port);
                if (hasStructureChange) continue;
                hasStructureChange = true;
            }
        }
        if (node.getChildCount() == 0) {
            log.error("Empty Node: refNodeSize={} toUpdate={}", (Object)node.getChildCount(), (Object)toUpdate);
        }
        if (monitors == null) {
            return;
        }
        if (hasStructureChange) {
            this.fireStructureChanged(monitors, node);
        } else if (!updated.isEmpty()) {
            for (Integer childIndex : updated.keySet()) {
                this.fireNodesUpdated(monitors, node, childIndex, (FVResourceNode)updated.get(childIndex));
            }
        }
    }
}

