/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor.tree;

import com.intel.stl.api.performance.IPerformanceApi;
import com.intel.stl.api.performance.VFConfigRspBean;
import com.intel.stl.api.performance.VFListBean;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.monitor.tree.CopyBasedNodesSynchronizer;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.monitor.tree.ITreeMonitor;
import com.intel.stl.ui.monitor.tree.TreeNodeFactory;
import com.intel.stl.ui.monitor.tree.TreeSynchronizer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class VirtualFabricsTreeSynchronizer
extends TreeSynchronizer<String> {
    private final IPerformanceApi perfApi;
    private final FVResourceNode deviceTypesTree;
    private Map<String, Integer> vfNames;
    private Map<Long, FVResourceNode> nodeMap;
    private final CopyBasedNodesSynchronizer nodesUpdater;
    private final Comparator<Long> comparator = new Comparator<Long>(){

        @Override
        public int compare(Long o1, Long o2) {
            FVResourceNode node = (FVResourceNode)VirtualFabricsTreeSynchronizer.this.nodeMap.get(o1);
            String name1 = node == null ? null : node.getName();
            node = (FVResourceNode)VirtualFabricsTreeSynchronizer.this.nodeMap.get(o2);
            String name2 = node == null ? null : node.getName();
            return TreeNodeFactory.comapreNodeName(name1, name2);
        }
    };

    public VirtualFabricsTreeSynchronizer(IPerformanceApi perfApi, FVResourceNode deviceTypesTree) {
        this(perfApi, deviceTypesTree, true);
    }

    public VirtualFabricsTreeSynchronizer(IPerformanceApi perfApi, FVResourceNode deviceTypesTree, boolean removeEmptyGroup) {
        super(removeEmptyGroup);
        this.perfApi = perfApi;
        this.deviceTypesTree = deviceTypesTree;
        this.initData();
        this.nodesUpdater = new CopyBasedNodesSynchronizer(this.nodeMap);
    }

    protected void initData() {
        List<VFListBean> groupList = this.perfApi.getVFList();
        if (groupList != null) {
            this.vfNames = new LinkedHashMap<String, Integer>();
            for (int i = 0; i < groupList.size(); ++i) {
                this.vfNames.put(groupList.get(i).getVfName(), i);
            }
        }
        this.nodeMap = new HashMap<Long, FVResourceNode>();
        for (FVResourceNode type : this.deviceTypesTree.getChildren()) {
            for (FVResourceNode node : type.getChildren()) {
                this.nodeMap.put(node.getGuid(), node);
            }
        }
    }

    public void updateTree(FVResourceNode parent, List<ITreeMonitor> monitors, IProgressObserver observer) {
        this.updateTree(parent, this.vfNames.keySet().toArray(new String[0]), monitors, observer);
    }

    @Override
    protected int compare(FVResourceNode node, String element) {
        return TreeNodeFactory.compareNameByIndex(node.getName(), element, this.vfNames);
    }

    @Override
    protected FVResourceNode createNode(String key) {
        Integer id = this.vfNames.get(key);
        if (id != null) {
            return TreeNodeFactory.createVfNode(key, id);
        }
        throw new IllegalArgumentException("Couldn't find vf '" + key + "'");
    }

    @Override
    protected FVResourceNode addNode(int index, String key, FVResourceNode parent, List<ITreeMonitor> monitors, IProgressObserver observer) {
        FVResourceNode node = super.addNode(index, key, parent, monitors, observer);
        this.updateNode(node, parent, monitors, observer);
        return node;
    }

    @Override
    protected void updateNode(FVResourceNode node, FVResourceNode parent, List<ITreeMonitor> monitors, IProgressObserver observer) {
        List<VFConfigRspBean> vfConfig = this.perfApi.getVFConfig(node.getName());
        if (vfConfig == null) {
            return;
        }
        HashSet<Long> elements = new HashSet<Long>();
        for (VFConfigRspBean bean : vfConfig) {
            long guid = bean.getPort().getNodeGUID();
            if (elements.contains(guid)) continue;
            elements.add(guid);
        }
        if (!elements.isEmpty()) {
            Long[] members = elements.toArray(new Long[0]);
            Arrays.sort(members, this.comparator);
            this.nodesUpdater.updateTree(node, members, monitors, observer);
        } else {
            Object[] children = new FVResourceNode[node.getChildCount()];
            int[] childIndex = new int[node.getChildCount()];
            int index = 0;
            while (node.getChildCount() > 0) {
                childIndex[index] = index;
                children[index++] = node.removeChild(0);
            }
            if (monitors != null) {
                for (ITreeMonitor monitor : monitors) {
                    monitor.fireTreeNodesRemoved(this, node.getPath().getPath(), childIndex, children);
                }
            }
        }
    }
}

