/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.view.ChartsView;
import com.intel.stl.ui.common.view.ISectionListener;
import com.intel.stl.ui.common.view.JSectionView;
import com.intel.stl.ui.configuration.view.IPropertyListener;
import com.intel.stl.ui.main.view.PerfDescCardView;
import com.intel.stl.ui.main.view.PerfErrorsCardView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class PerformanceErrorsSectionView
extends JSectionView<ISectionListener> {
    private static final long serialVersionUID = 317632809509908254L;
    private PerfErrorsCardView errorsCardView;
    private PerfDescCardView descCardView;
    private JPanel counterPanel;
    private JToolBar toolBar;
    private JButton borderBtn;
    private JButton alternationBtn;
    private IPropertyListener listener;

    public PerformanceErrorsSectionView() {
        super(STLConstants.K0741_COUNTERS.getValue());
    }

    @Override
    protected JComponent getMainComponent() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(5, 5));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        mainPanel.add(this.getCtrlPanel(), "North");
        this.errorsCardView = new PerfErrorsCardView(STLConstants.K0705_PORT_COUNTERS.getValue());
        mainPanel.add((Component)this.errorsCardView, "West");
        this.descCardView = new PerfDescCardView(STLConstants.K0749_PORT_COUNTER_DESC.getValue());
        this.counterPanel = new JPanel();
        mainPanel.add((Component)this.counterPanel, "Center");
        return mainPanel;
    }

    public void installChartView(ChartsView chartCardView) {
        if (this.counterPanel != null) {
            this.counterPanel.removeAll();
            this.counterPanel.setLayout(new GridLayout(2, 1, 5, 5));
            this.counterPanel.add(chartCardView);
            this.counterPanel.add(this.descCardView);
            this.revalidate();
        }
    }

    protected Component getCtrlPanel() {
        if (this.toolBar == null) {
            this.toolBar = new JToolBar();
            this.toolBar.setFloatable(false);
            this.addStyleButtons();
        }
        return this.toolBar;
    }

    protected void addStyleButtons() {
        this.borderBtn = new JButton(STLConstants.K0530_SHOW_BORDER.getValue(), UIImages.HIDE_BORDER.getImageIcon());
        this.borderBtn.setOpaque(false);
        this.borderBtn.setFocusable(false);
        this.borderBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isSelected = PerformanceErrorsSectionView.this.borderBtn.getIcon() != UIImages.SHOW_BORDER.getImageIcon();
                PerformanceErrorsSectionView.this.setShowBorder(isSelected);
                if (PerformanceErrorsSectionView.this.listener != null) {
                    PerformanceErrorsSectionView.this.listener.onShowBorder(isSelected);
                }
            }
        });
        this.toolBar.add(this.borderBtn);
        this.alternationBtn = new JButton(STLConstants.K0533_UNI_ROWS.getValue(), UIImages.UNI_ROWS.getImageIcon());
        this.alternationBtn.setOpaque(false);
        this.alternationBtn.setFocusable(false);
        this.alternationBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isSelected = PerformanceErrorsSectionView.this.alternationBtn.getIcon() != UIImages.ALT_ROWS.getImageIcon();
                PerformanceErrorsSectionView.this.setShowAlternation(isSelected);
                if (PerformanceErrorsSectionView.this.listener != null) {
                    PerformanceErrorsSectionView.this.listener.onShowAlternation(isSelected);
                }
            }
        });
        this.toolBar.add(this.alternationBtn);
    }

    public void setStyleListener(IPropertyListener listener) {
        this.listener = listener;
    }

    protected void setShowBorder(boolean isSelected) {
        if (isSelected) {
            this.borderBtn.setIcon(UIImages.SHOW_BORDER.getImageIcon());
            this.borderBtn.setText(STLConstants.K0530_SHOW_BORDER.getValue());
        } else {
            this.borderBtn.setIcon(UIImages.HIDE_BORDER.getImageIcon());
            this.borderBtn.setText(STLConstants.K0531_HIDE_BORDER.getValue());
        }
    }

    protected void setShowAlternation(boolean isSelected) {
        if (isSelected) {
            this.alternationBtn.setIcon(UIImages.ALT_ROWS.getImageIcon());
            this.alternationBtn.setText(STLConstants.K0532_ALT_ROWS.getValue());
        } else {
            this.alternationBtn.setIcon(UIImages.UNI_ROWS.getImageIcon());
            this.alternationBtn.setText(STLConstants.K0533_UNI_ROWS.getValue());
        }
    }

    public PerfErrorsCardView getErrorsCardView() {
        return this.errorsCardView;
    }

    public PerfDescCardView getDescCardView() {
        return this.descCardView;
    }
}

