/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor.view;

import com.intel.stl.ui.common.IBackgroundService;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.view.IntelSplitPaneUI;
import com.intel.stl.ui.monitor.TreeTypeEnum;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.monitor.tree.FVTreeModel;
import com.intel.stl.ui.monitor.view.IStack;
import com.intel.stl.ui.monitor.view.SearchView;
import com.intel.stl.ui.monitor.view.StackPanel;
import com.intel.stl.ui.monitor.view.TreeViewInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.EnumMap;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ScrollPaneLayout;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public abstract class TreeView
extends JPanel
implements TreeViewInterface,
IStack {
    private static final long serialVersionUID = 849119323304459300L;
    private JPanel mPnlTree;
    private EnumMap<TreeTypeEnum, StackPanel> stackPanels;
    private JLabel mlblStatus;
    protected final IBackgroundService graphService;
    protected final IBackgroundService outlineService;
    private SearchView searchView;

    public TreeView(IBackgroundService graphService, IBackgroundService outlineService) {
        this.graphService = graphService;
        this.outlineService = outlineService;
        this.setOpaque(true);
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JSplitPane spltpnMain = new JSplitPane(1);
        spltpnMain.setResizeWeight(0.02);
        spltpnMain.setDividerSize(5);
        JSplitPane splpnTree = new JSplitPane(0);
        splpnTree.setMinimumSize(new Dimension(250, 300));
        splpnTree.setResizeWeight(0.8);
        splpnTree.setDividerSize(15);
        splpnTree.setUI(new IntelSplitPaneUI());
        splpnTree.setOneTouchExpandable(true);
        this.mPnlTree = new JPanel(new GridBagLayout());
        this.mPnlTree.setBackground(UIConstants.INTEL_WHITE);
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.gridwidth = 0;
        this.stackPanels = this.getStackPanels();
        for (StackPanel panel : this.stackPanels.values()) {
            this.mPnlTree.add((Component)panel, gc);
        }
        gc.weighty = 1.0;
        this.mPnlTree.add(Box.createGlue(), gc);
        JScrollPane scrpnTree = new JScrollPane();
        ScrollPaneLayout spTreeLayout = new ScrollPaneLayout();
        scrpnTree.createHorizontalScrollBar();
        scrpnTree.createVerticalScrollBar();
        spTreeLayout.setHorizontalScrollBarPolicy(30);
        spTreeLayout.setVerticalScrollBarPolicy(20);
        scrpnTree.getVerticalScrollBar().setUnitIncrement(10);
        scrpnTree.setLayout(spTreeLayout);
        this.searchView = new SearchView();
        splpnTree.setBottomComponent(this.searchView);
        scrpnTree.add(this.mPnlTree);
        scrpnTree.setViewportView(this.mPnlTree);
        splpnTree.setTopComponent(scrpnTree);
        spltpnMain.setLeftComponent(splpnTree);
        JComponent rightComp = this.getDataComponent();
        rightComp.setOpaque(false);
        spltpnMain.setRightComponent(this.getMainComponent());
        this.add((Component)spltpnMain, "Center");
    }

    public SearchView getSearchView() {
        return this.searchView;
    }

    protected JComponent getDataComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        this.mlblStatus = new JLabel("Data Goes Here!!!");
        this.mlblStatus.setFont(UIConstants.H3_FONT.deriveFont(1));
        panel.add(this.mlblStatus);
        return panel;
    }

    protected EnumMap<TreeTypeEnum, StackPanel> getStackPanels() {
        EnumMap<TreeTypeEnum, StackPanel> panels = new EnumMap<TreeTypeEnum, StackPanel>(TreeTypeEnum.class);
        panels.put(TreeTypeEnum.DEVICE_TYPES_TREE, new StackPanel(TreeTypeEnum.DEVICE_TYPES_TREE, this.createTree(), this));
        panels.put(TreeTypeEnum.DEVICE_GROUPS_TREE, new StackPanel(TreeTypeEnum.DEVICE_GROUPS_TREE, this.createTree(), this));
        panels.put(TreeTypeEnum.VIRTUAL_FABRICS_TREE, new StackPanel(TreeTypeEnum.VIRTUAL_FABRICS_TREE, this.createTree(), this));
        return panels;
    }

    protected JTree createTree() {
        JTree res = new JTree();
        res.setModel(null);
        return res;
    }

    @Override
    public void stackChange(TreeTypeEnum stack) {
        for (TreeTypeEnum id : this.stackPanels.keySet()) {
            if (id == stack) continue;
            this.stackPanels.get((Object)id).close();
        }
    }

    protected void showNode(FVResourceNode node) {
        this.mlblStatus.setText("You have selected node: " + node);
    }

    @Override
    public void addTreeSelectionListener(TreeSelectionListener treeListener) {
        for (TreeTypeEnum id : this.stackPanels.keySet()) {
            this.stackPanels.get((Object)id).addTreeListener(treeListener);
        }
    }

    protected abstract JComponent getMainComponent();

    @Override
    public void setViewSize(Dimension pSize) {
        this.setPreferredSize(pSize);
    }

    @Override
    public JPanel getMainPanel() {
        return this;
    }

    @Override
    public void setTreeModel(final TreeTypeEnum pTreeType, final FVTreeModel pModel) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                TreeView.this.getStackPanel(pTreeType).setTreeModel(pModel);
            }
        });
    }

    @Override
    public void setTreeSelection(final TreeTypeEnum pTreeType) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                StackPanel sp = TreeView.this.getStackPanel(pTreeType);
                sp.open();
            }
        });
    }

    @Override
    public void setTreeSelection(final TreeTypeEnum pTreeType, final int index) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                StackPanel sp = TreeView.this.getStackPanel(pTreeType);
                sp.open();
                sp.select(index);
            }
        });
    }

    protected StackPanel getStackPanel(TreeTypeEnum type) {
        StackPanel sp = this.stackPanels.get((Object)type);
        if (sp != null) {
            return sp;
        }
        throw new IllegalArgumentException("Couldn't find StackPanel for " + (Object)((Object)type));
    }

    public void setTreeSelection(final FVTreeModel model, final TreePath[] paths) {
        final boolean[] isExpanded = new boolean[paths.length];
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                for (StackPanel sp : TreeView.this.stackPanels.values()) {
                    if (sp.getTreeModel() != model) continue;
                    sp.select(paths, isExpanded);
                }
            }
        });
    }

    public void clearTreeSelection(final FVTreeModel model) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                for (StackPanel sp : TreeView.this.stackPanels.values()) {
                    if (sp.getTreeModel() != model) continue;
                    sp.clearSelection();
                }
            }
        });
    }

    public void collapseTreePath(FVTreeModel model, TreePath path) {
        for (StackPanel sp : this.stackPanels.values()) {
            if (sp.getTreeModel() != model) continue;
            sp.collapse(path);
        }
    }

    public void expandTreePath(FVTreeModel model, TreePath path) {
        for (StackPanel sp : this.stackPanels.values()) {
            if (sp.getTreeModel() != model) continue;
            sp.expand(path);
        }
    }

    @Override
    public void expandAndSelectTreePath(FVTreeModel model, TreePath[] paths, boolean[] isExpanded) {
        for (StackPanel sp : this.stackPanels.values()) {
            if (sp.getTreeModel() == model) {
                if (!sp.isOpened()) {
                    sp.open();
                }
                sp.select(paths, isExpanded);
                continue;
            }
            sp.close();
        }
    }

    public void ensureSelectionVisible(final FVTreeModel model) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                for (StackPanel sp : TreeView.this.stackPanels.values()) {
                    if (sp.getTreeModel() != model) continue;
                    sp.ensureSelectionVisible();
                }
            }
        });
    }

    @Override
    public void setSelectionMode(int selectionMode) {
        for (StackPanel sp : this.stackPanels.values()) {
            sp.setSelectionMode(selectionMode);
        }
    }

    @Override
    public void clear() {
        this.setTreeSelection(TreeTypeEnum.DEVICE_TYPES_TREE, 0);
        this.stackChange(TreeTypeEnum.DEVICE_TYPES_TREE);
    }
}

