/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network;

import com.intel.stl.api.subnet.LinkRecordBean;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.model.GraphNode;
import com.intel.stl.ui.network.TopGraph;
import com.intel.stl.ui.network.TopologyTreeModel;
import com.mxgraph.model.mxCell;
import com.mxgraph.view.mxGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphBuilder {
    private static final Logger log = LoggerFactory.getLogger(GraphBuilder.class);
    public static final int SWITCH_SIZE = 64;
    public static final int HFI_SIZE = 32;
    private static boolean DEBUG = false;

    public TopologyTreeModel build(TopGraph graph, List<NodeRecordBean> nodes, List<LinkRecordBean> links) {
        List<GraphNode> roots;
        long t = System.currentTimeMillis();
        log.info("Create graph with " + nodes.size() + " nodes, " + links.size() + " links");
        HashMap<Integer, GraphNode> nodesMap = new HashMap<Integer, GraphNode>();
        HashSet<GraphNode> endNodes = new HashSet<GraphNode>();
        for (NodeRecordBean node : nodes) {
            GraphNode gn = new GraphNode(node.getLid());
            gn.setName(node.getNodeDesc());
            gn.setType(node.getNodeInfo().getNodeType());
            gn.setNumPorts(node.getNodeInfo().getNumPorts());
            if (gn.isEndNode()) {
                gn.setDepth(0);
                endNodes.add(gn);
            }
            nodesMap.put(node.getLid(), gn);
        }
        this.fillLinks(nodesMap, links);
        List<GraphNode> list = roots = endNodes.isEmpty() ? this.getRoots(nodesMap.values()) : this.getRoots(nodesMap.values(), endNodes);
        if (DEBUG) {
            for (GraphNode node : nodesMap.values()) {
                node.dump(System.out);
            }
        }
        log.info("Found " + roots.size() + " root nodes");
        if (DEBUG) {
            System.out.println("Roots: " + roots);
        }
        graph.clear();
        TopologyTreeModel model = this.fillGraph(graph, roots);
        log.info("Created graph " + (Object)((Object)graph) + " in " + (System.currentTimeMillis() - t) + " ms " + Thread.currentThread());
        return model;
    }

    protected Set<GraphNode> screenEndNodes(Set<GraphNode> endNodes) {
        HashSet<GraphNode> leafSwitches = new HashSet<GraphNode>();
        for (GraphNode node : endNodes) {
            Set<GraphNode> nbr = node.getMiddleNeighbor();
            for (GraphNode parent : nbr) {
                if (leafSwitches.contains(parent)) continue;
                leafSwitches.add(parent);
            }
        }
        if (leafSwitches.size() <= 2) {
            return endNodes;
        }
        HashSet<GraphNode> toRemove = new HashSet<GraphNode>();
        block2: for (GraphNode node : leafSwitches) {
            Set<GraphNode> nbrs = node.getMiddleNeighbor();
            int numHosts = node.getEndNeighbor().size();
            for (GraphNode peer : nbrs) {
                if (!leafSwitches.contains(peer) || toRemove.contains(peer)) continue;
                if (peer.getEndNeighbor().size() > numHosts) {
                    toRemove.add(node);
                    continue block2;
                }
                toRemove.add(peer);
            }
        }
        leafSwitches.removeAll(toRemove);
        HashSet<GraphNode> res = new HashSet<GraphNode>();
        for (GraphNode node : leafSwitches) {
            res.addAll(node.getEndNeighbor());
        }
        if (res.isEmpty()) {
            return endNodes;
        }
        return res;
    }

    protected void fillLinks(Map<Integer, GraphNode> map, List<LinkRecordBean> links) {
        for (LinkRecordBean link : links) {
            int fromLid = link.getFromLID();
            GraphNode node = map.get(fromLid);
            int toLid = link.getToLID();
            GraphNode toNode = map.get(toLid);
            if (node != null && toNode != null) {
                node.addLink(toNode, link.getFromPortIndex(), link.getToPortIndex());
                continue;
            }
            if (node == null) {
                log.warn("Node " + fromLid + " are not in node list");
            }
            if (toNode != null) continue;
            log.warn("Node " + toLid + " are not in node list");
        }
    }

    protected List<GraphNode> getRoots(Collection<GraphNode> nodes, Set<GraphNode> endNodes) {
        HashSet<GraphNode> workingNodes = new HashSet<GraphNode>(nodes);
        workingNodes.removeAll(endNodes);
        HashSet<GraphNode> nextRef = new HashSet<GraphNode>(this.screenEndNodes(endNodes));
        boolean hasChange = true;
        while (!workingNodes.isEmpty() && hasChange) {
            HashSet<GraphNode> refNodes = nextRef;
            nextRef = new HashSet();
            hasChange = false;
            for (GraphNode ref : refNodes) {
                for (GraphNode gn : ref.getMiddleNeighbor()) {
                    boolean success = workingNodes.remove(gn);
                    if (success) {
                        nextRef.add(gn);
                        gn.setDepth(ref.getDepth() + 1);
                    }
                    if (hasChange) continue;
                    hasChange = true;
                }
            }
        }
        ArrayList<GraphNode> res = new ArrayList<GraphNode>(nextRef);
        if (!workingNodes.isEmpty()) {
            res.addAll(workingNodes);
            log.warn("Found isolated nodes " + workingNodes.size());
        }
        Collections.sort(res);
        return res;
    }

    protected List<GraphNode> getRoots(Collection<GraphNode> nodes) {
        HashSet<GraphNode> refNodes = new HashSet<GraphNode>();
        int minNumLinks = Integer.MAX_VALUE;
        for (GraphNode node : nodes) {
            int links = node.getMiddleNeighbor().size();
            if (links < minNumLinks) {
                refNodes.clear();
                refNodes.add(node);
                continue;
            }
            if (links != minNumLinks) continue;
            refNodes.add(node);
        }
        return this.getRoots(nodes, refNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TopologyTreeModel fillGraph(TopGraph graph, List<GraphNode> roots) {
        ArrayList<List<Integer>> ranks = new ArrayList<List<Integer>>();
        int maxRankSize = 0;
        int numNodes = 0;
        HashSet<GraphNode> processed = new HashSet<GraphNode>();
        Object parent = graph.getDefaultParent();
        graph.getModel().beginUpdate();
        try {
            TopologyTreeModel model;
            for (GraphNode node : roots) {
                this.insertVertex(graph, parent, node);
            }
            ArrayList<GraphNode> nextNodes = new ArrayList<GraphNode>(roots);
            while (!nextNodes.isEmpty()) {
                ArrayList<Integer> rank = new ArrayList<Integer>();
                for (GraphNode node : nextNodes) {
                    rank.add(node.getLid());
                }
                ranks.add(Collections.unmodifiableList(rank));
                numNodes += rank.size();
                if (nextNodes.size() > maxRankSize) {
                    maxRankSize = nextNodes.size();
                }
                ArrayList<GraphNode> workingNodes = nextNodes;
                nextNodes = new ArrayList();
                for (GraphNode node : workingNodes) {
                    String edgeId;
                    mxCell nbrVertex;
                    mxCell vertex = graph.getVertex(node.getLid());
                    Set<GraphNode> neighbor = node.getMiddleNeighbor();
                    for (GraphNode nbr : neighbor) {
                        if (processed.contains(nbr)) continue;
                        nbrVertex = graph.getVertex(nbr.getLid());
                        if (nbrVertex == null) {
                            nbrVertex = this.insertVertex(graph, parent, nbr);
                        }
                        edgeId = TopGraph.getEdgeId(vertex, nbrVertex);
                        graph.insertEdge(parent, edgeId, null, vertex, nbrVertex);
                        if (nextNodes.contains(nbr) || workingNodes.contains(nbr)) continue;
                        nextNodes.add(nbr);
                    }
                    neighbor = node.getEndNeighbor();
                    numNodes += neighbor.size();
                    for (GraphNode nbr : neighbor) {
                        if (processed.contains(nbr)) continue;
                        nbrVertex = graph.getVertex(nbr.getLid());
                        if (nbrVertex == null) {
                            nbrVertex = this.insertVertex(graph, parent, nbr);
                        }
                        edgeId = TopGraph.getEdgeId(vertex, nbrVertex);
                        graph.insertEdge(parent, edgeId, null, vertex, nbrVertex);
                    }
                }
                processed.addAll(workingNodes);
            }
            TopologyTreeModel topologyTreeModel = model = new TopologyTreeModel(ranks, maxRankSize, new ArrayList<Integer>(), numNodes);
            return topologyTreeModel;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            graph.getModel().endUpdate();
        }
        return null;
    }

    protected mxCell insertVertex(mxGraph graph, Object parent, GraphNode nbr) {
        NodeType type = NodeType.getNodeType(nbr.getType());
        int w = type == NodeType.HFI ? 32 : 64;
        int h = type == NodeType.HFI ? 32 : 64;
        String style = type == NodeType.HFI ? "shape=image;image=" + UIImages.HFI_IMG.getFileName() : "shape=image;image=" + UIImages.SWITCH_EXPANDED_IMG.getFileName();
        Object vertex = graph.insertVertex(parent, TopGraph.getVertexId(nbr.getLid()), (Object)nbr, 0.0, 0.0, (double)w, (double)h, style);
        return (mxCell)vertex;
    }
}

