/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network;

import com.intel.stl.ui.common.ICancelIndicator;
import com.intel.stl.ui.model.LayoutType;
import com.intel.stl.ui.network.IModelChange;
import com.intel.stl.ui.network.TopGraph;
import com.intel.stl.ui.network.TopologyTreeModel;
import com.intel.stl.ui.network.TreeLayout;
import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.layout.mxFastOrganicLayout;
import com.mxgraph.view.mxGraph;

public class LayoutChange
implements IModelChange {
    private final TopologyTreeModel topTreeModel;
    private final LayoutType type;

    public LayoutChange(LayoutType type, TopologyTreeModel topTreeModel) {
        this.type = type;
        this.topTreeModel = topTreeModel;
    }

    @Override
    public boolean execute(TopGraph graph, ICancelIndicator indicator) {
        Object layout = null;
        switch (this.type) {
            case FORCE_DIRECTED: {
                graph.expandAll();
                layout = new mxFastOrganicLayout((mxGraph)graph);
                break;
            }
            case HIERARCHICAL: {
                graph.expandAll();
                layout = new mxHierarchicalLayout((mxGraph)graph);
                break;
            }
            case TREE_CIRCLE: {
                layout = new TreeLayout(graph, this.topTreeModel, TreeLayout.Style.CIRCLE);
                break;
            }
            case TREE_SLASH: {
                layout = new TreeLayout(graph, this.topTreeModel, TreeLayout.Style.SLASH);
                break;
            }
            case TREE_LINE: {
                layout = new TreeLayout(graph, this.topTreeModel, TreeLayout.Style.LINE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + (Object)((Object)this.type));
            }
        }
        if (layout instanceof TreeLayout) {
            ((TreeLayout)((Object)layout)).execute(graph.getDefaultParent(), indicator);
        } else {
            layout.execute(graph.getDefaultParent());
        }
        return true;
    }
}

