/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network;

import com.intel.stl.ui.common.ICancelIndicator;
import com.intel.stl.ui.model.GraphNode;
import com.intel.stl.ui.model.LayoutType;
import com.intel.stl.ui.network.LayoutChange;
import com.intel.stl.ui.network.TopGraph;
import com.intel.stl.ui.network.TopologyTreeModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodesVisibilityChange
extends LayoutChange {
    private static final Logger log = LoggerFactory.getLogger(NodesVisibilityChange.class);
    private int[] toInspect;

    public NodesVisibilityChange(LayoutType type, TopologyTreeModel topTreeModel, int[] toInspect) {
        super(type, topTreeModel);
        this.toInspect = toInspect;
    }

    @Override
    public boolean execute(TopGraph graph, ICancelIndicator indicator) {
        boolean hasChange = false;
        for (int lid : this.toInspect) {
            GraphNode node = (GraphNode)graph.getVertex(lid).getValue();
            if (!node.isEndNode()) continue;
            for (GraphNode nbr : node.getMiddleNeighbor()) {
                if (!nbr.isCollapsed()) continue;
                nbr.setCollapsed(false);
                if (hasChange) continue;
                hasChange = true;
            }
        }
        int lid = this.toInspect[this.toInspect.length - 1];
        GraphNode node = (GraphNode)graph.getVertex(lid).getValue();
        if (node.hasEndNodes()) {
            node.setCollapsed(!node.isCollapsed());
            if (!hasChange) {
                hasChange = true;
            }
        }
        if (hasChange) {
            super.execute(graph, indicator);
        }
        return hasChange;
    }
}

