/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network;

import com.intel.stl.api.subnet.ISubnetApi;
import com.intel.stl.api.subnet.NodeInfoBean;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.ui.common.IPageController;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.PageWeight;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.model.ConnectivityTableModel;
import com.intel.stl.ui.model.GraphEdge;
import com.intel.stl.ui.monitor.ConnectivityTableController;
import com.intel.stl.ui.monitor.view.ConnectivitySubpageView;
import com.intel.stl.ui.network.view.ResourceLinkView;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import org.jfree.util.Log;

public class ResourceLinkPage
implements IPageController {
    private static final byte NUM_TAB_CHARS = 12;
    private final ResourceLinkView view;
    private final ConnectivityTableController tableController;
    private ISubnetApi subnetApi;
    private String pageName = STLConstants.K0013_LINKS.getValue();
    private String pageDescription = new String(STLConstants.K1023_LINK_RESOURCE_DESCRIPTION.getValue());

    public ResourceLinkPage(ConnectivityTableModel tableModel, ConnectivitySubpageView tableView, ResourceLinkView view) {
        this.view = view;
        this.view.addTableView(tableView);
        this.tableController = new ConnectivityTableController(tableModel, tableView.getTable());
    }

    @Override
    public void setContext(Context context, IProgressObserver observer) {
        this.subnetApi = context.getSubnetApi();
        this.tableController.setContext(context, null);
        if (observer != null) {
            observer.onFinish();
        }
    }

    @Override
    public void onRefresh(IProgressObserver observer) {
    }

    @Override
    public String getName() {
        return this.pageName;
    }

    @Override
    public String getDescription() {
        return this.pageDescription;
    }

    @Override
    public Component getView() {
        return this.view;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void onEnter() {
    }

    @Override
    public void onExit() {
    }

    @Override
    public boolean canExit() {
        return true;
    }

    @Override
    public void clear() {
        this.tableController.clear();
    }

    private String createNodeName(String name) {
        return Util.truncateString(name, 1, 12);
    }

    private String createToolTip(String fromName, int fromLid, String toName, int toLid) {
        String toolTip = new String("");
        try {
            NodeInfoBean fromNode = this.subnetApi.getNode(fromLid).getNodeInfo();
            NodeInfoBean toNode = this.subnetApi.getNode(toLid).getNodeInfo();
            String fromGuid = String.format("%#020x", fromNode.getNodeGUID());
            String toGuid = String.format("%#020x", toNode.getNodeGUID());
            toolTip = "<html>" + fromName + " GUID=" + fromGuid + "  LID=" + fromLid + "<br>" + toName + " GUID=" + toGuid + "  LID=" + toLid + "</html>";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toolTip;
    }

    private String createToolTip(String fromName, int fromLid, int fromPort, String toName, int toLid, int toPort) {
        String toolTip = new String("");
        try {
            NodeInfoBean fromNode = this.subnetApi.getNode(fromLid).getNodeInfo();
            NodeInfoBean toNode = this.subnetApi.getNode(toLid).getNodeInfo();
            String fromGuid = String.format("%#020x", fromNode.getNodeGUID());
            String toGuid = String.format("%#020x", toNode.getNodeGUID());
            toolTip = "<html>" + fromName + " GUID=" + fromGuid + "  LID=" + fromLid + " PORT=" + fromPort + "<br>" + toName + " GUID=" + toGuid + "  LID=" + toLid + " PORT=" + toPort + "</html>";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toolTip;
    }

    protected String getNodeName(int lid) {
        String nodeName = new String("");
        try {
            nodeName = this.subnetApi.getNode(lid).getNodeDesc();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nodeName;
    }

    public void showLink(GraphEdge edge, String vfName) {
        short[] ports;
        if (edge.getLinks().size() == 1) {
            NodeRecordBean fromNodeBean = null;
            NodeRecordBean toNodeBean = null;
            try {
                fromNodeBean = this.subnetApi.getNode(edge.getFromLid());
                toNodeBean = this.subnetApi.getNode(edge.getToLid());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (fromNodeBean == null || toNodeBean == null) {
                Log.warn((Object)("Couldn't fond nodes for link " + edge));
                this.tableController.clear();
                return;
            }
            Map.Entry<Integer, Integer> link = edge.getLinks().entrySet().iterator().next();
            String fromName = this.createNodeName(fromNodeBean.getNodeDesc()) + " : " + link.getKey();
            String toName = this.createNodeName(toNodeBean.getNodeDesc()) + " : " + link.getValue();
            this.setName(fromName + "," + toName);
            String description = this.createToolTip(fromName, edge.getFromLid(), link.getKey(), toName, edge.getToLid(), link.getValue());
            this.setDescription(description);
            ArrayList<Short> portList = new ArrayList<Short>();
            Map<Integer, Integer> links = edge.getLinks();
            Iterator<Map.Entry<Integer, Integer>> it = links.entrySet().iterator();
            while (it.hasNext()) {
                Integer portNum = it.next().getKey();
                portList.add(portNum.shortValue());
            }
            Short[] pShorts = portList.toArray(new Short[portList.size()]);
            ports = new short[pShorts.length];
            for (int i = 0; i < pShorts.length; ++i) {
                ports[i] = pShorts[i];
            }
        } else {
            throw new IllegalArgumentException("Link has more than one paire of ports!");
        }
        this.tableController.showConnectivity(edge.getFromLid(), vfName, null, ports);
    }

    public void showPath(GraphEdge trace, List<GraphEdge> links, String vfName) {
        LinkedHashMap<GraphEdge, Short> portMap = new LinkedHashMap<GraphEdge, Short>();
        for (GraphEdge link : links) {
            for (Map.Entry<Integer, Integer> entry : link.getLinks().entrySet()) {
                short fromPortNum = entry.getKey().shortValue();
                try {
                    NodeRecordBean nrb = this.subnetApi.getNode(link.getFromLid());
                    if (nrb.getNodeType() == NodeType.HFI) {
                        fromPortNum = nrb.getNodeInfo().getLocalPortNum();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                portMap.put(link, fromPortNum);
            }
        }
        String fromName = this.createNodeName(this.getNodeName(trace.getFromLid()));
        String toName = this.createNodeName(this.getNodeName(trace.getToLid()));
        this.setName(new String(fromName + "," + toName));
        String description = this.createToolTip(fromName, trace.getFromLid(), toName, trace.getToLid());
        this.setDescription(description);
        this.tableController.showPathConnectivity(portMap, vfName, null);
    }

    public void setName(String name) {
        this.pageName = name;
    }

    public void setDescription(String description) {
        this.pageDescription = description;
    }

    @Override
    public PageWeight getContextSwitchWeight() {
        return PageWeight.MEDIUM;
    }

    @Override
    public PageWeight getRefreshWeight() {
        return PageWeight.MEDIUM;
    }
}

