/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network;

import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.PageWeight;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.model.ConnectivityTableModel;
import com.intel.stl.ui.model.GraphNode;
import com.intel.stl.ui.monitor.ConnectivityTableController;
import com.intel.stl.ui.monitor.TreeNodeType;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.monitor.view.ConnectivitySubpageView;
import com.intel.stl.ui.network.IResourceNodeSubpageController;
import com.intel.stl.ui.network.view.ResourcePortView;
import java.awt.Component;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.ImageIcon;

public class ResourcePortPage
implements IResourceNodeSubpageController {
    private final ResourcePortView pageView;
    private ConnectivityTableController tableController;

    public ResourcePortPage(ResourcePortView view) {
        this.pageView = view;
    }

    public ResourcePortPage(ConnectivityTableModel tableModel, ConnectivitySubpageView tableView, ResourcePortView pageView) {
        this.pageView = pageView;
        this.pageView.addTableView(tableView);
        this.tableController = new ConnectivityTableController(tableModel, tableView.getTable());
    }

    @Override
    public void setContext(Context context, IProgressObserver observer) {
        this.tableController.setContext(context, null);
        if (observer != null) {
            observer.onFinish();
        }
    }

    @Override
    public void onRefresh(IProgressObserver observer) {
    }

    @Override
    public String getName() {
        return STLConstants.K0415_CONNECTIVITY.getValue();
    }

    @Override
    public String getDescription() {
        return STLConstants.K0416_CONNECTIVITY_DESCRIPTION.getValue();
    }

    @Override
    public Component getView() {
        return this.pageView;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void onEnter() {
    }

    @Override
    public void onExit() {
    }

    @Override
    public boolean canExit() {
        return true;
    }

    @Override
    public void clear() {
        this.tableController.clear();
    }

    @Override
    public void showNode(FVResourceNode source, GraphNode node) {
        String vfName = null;
        FVResourceNode group = source.getParent();
        if (group.getType() == TreeNodeType.VIRTUAL_FABRIC) {
            vfName = group.getTitle();
        }
        this.processNode(source, NodeType.getNodeType(node.getType()), vfName);
    }

    protected void processNode(FVResourceNode node, NodeType nodeType, String vfName) {
        Vector<FVResourceNode> children = node.getChildren();
        if (children.size() >= 1) {
            short[] ports = null;
            if (nodeType == NodeType.SWITCH) {
                ports = new short[children.size() - 1];
                for (int i = 1; i < children.size(); ++i) {
                    ports[i - 1] = (short)children.get(i).getId();
                }
            } else {
                ports = new short[children.size()];
                for (int i = 0; i < children.size(); ++i) {
                    ports[i] = (short)children.get(i).getId();
                }
            }
            this.tableController.showConnectivity(node.getId(), vfName, null, ports);
        }
    }

    protected void processNode(GraphNode node, NodeType nodeType, String vfName) {
        TreeMap<Integer, Integer> neighbor;
        TreeMap<GraphNode, TreeMap<Integer, Integer>> middleNodes = node.getMiddleNodes();
        ArrayList<Short> portList = new ArrayList<Short>();
        if (middleNodes != null && middleNodes.keySet().size() > 0) {
            for (GraphNode gNode : node.getMiddleNodes().keySet()) {
                neighbor = node.getMiddleNodes().get(gNode);
                for (Integer portNum : neighbor.keySet()) {
                    portList.add(portNum.shortValue());
                }
            }
        }
        if (node.getEndNodes() != null) {
            for (GraphNode gNode : node.getEndNodes().keySet()) {
                neighbor = node.getEndNodes().get(gNode);
                for (Integer portNum : neighbor.keySet()) {
                    portList.add(portNum.shortValue());
                }
            }
        }
        Short[] pShorts = portList.toArray(new Short[portList.size()]);
        short[] ports = new short[pShorts.length];
        for (int i = 0; i < pShorts.length; ++i) {
            ports[i] = pShorts[i];
            if (nodeType != NodeType.HFI) continue;
            int n = i;
            ports[n] = (short)(ports[n] + 1);
        }
        this.tableController.showConnectivity(node.getLid(), vfName, null, ports);
    }

    @Override
    public PageWeight getContextSwitchWeight() {
        return PageWeight.MEDIUM;
    }

    @Override
    public PageWeight getRefreshWeight() {
        return PageWeight.MEDIUM;
    }
}

