/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network;

import com.intel.stl.api.subnet.ISubnetApi;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.api.subnet.SubnetDataNotFoundException;
import com.intel.stl.ui.common.ICancelIndicator;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.model.NodeTypeViz;
import com.intel.stl.ui.model.PropertyItem;
import com.intel.stl.ui.model.SimplePropertyCategory;
import com.intel.stl.ui.model.SimplePropertyGroup;
import com.intel.stl.ui.model.SimplePropertyKey;
import java.util.EnumMap;

public class SubnetSummaryProcessor {
    private final String name;
    private final ISubnetApi subnetApi;
    private final ICancelIndicator cancelIndicator;

    public SubnetSummaryProcessor(String name, ISubnetApi subnetApi, ICancelIndicator cancelIndicator) {
        this.subnetApi = subnetApi;
        this.cancelIndicator = cancelIndicator;
        this.name = name;
    }

    public SimplePropertyGroup populate() {
        SimplePropertyGroup group = new SimplePropertyGroup(this.name);
        if (!this.cancelIndicator.isCancelled()) {
            group.addPropertyCategory(this.populateNodes());
        }
        if (!this.cancelIndicator.isCancelled()) {
            group.addPropertyCategory(this.populatePorts());
        }
        return group;
    }

    protected SimplePropertyCategory populateNodes() {
        SimplePropertyCategory category = new SimplePropertyCategory(STLConstants.K0014_ACTIVE_NODES.getValue(), null);
        category.setShowHeader(true);
        try {
            EnumMap<NodeType, Integer> dist = this.subnetApi.getNodesTypeDist(false, false);
            NodeTypeViz type = NodeTypeViz.SWITCH;
            Integer count = dist.get((Object)type.getType());
            PropertyItem<SimplePropertyKey> item = this.populateCountItem(type, (long)count);
            category.addItem(item);
            type = NodeTypeViz.HFI;
            count = dist.get((Object)type.getType());
            item = this.populateCountItem(type, (long)count);
            category.addItem(item);
        }
        catch (SubnetDataNotFoundException e) {
            e.printStackTrace();
        }
        return category;
    }

    protected SimplePropertyCategory populatePorts() {
        SimplePropertyCategory category = new SimplePropertyCategory(STLConstants.K0024_ACTIVE_PORTS.getValue(), null);
        category.setShowHeader(true);
        try {
            EnumMap<NodeType, Long> dist = this.subnetApi.getPortsTypeDist(true, false);
            NodeTypeViz type = NodeTypeViz.SWITCH;
            Long count = dist.get((Object)type.getType());
            PropertyItem<SimplePropertyKey> item = this.populateCountItem(type, count);
            category.addItem(item);
            type = NodeTypeViz.HFI;
            count = dist.get((Object)type.getType());
            item = this.populateCountItem(type, count);
            category.addItem(item);
            type = NodeTypeViz.OTHER;
            count = dist.get((Object)type.getType());
            item = this.populateCountItem(type, count);
            category.addItem(item);
        }
        catch (SubnetDataNotFoundException e) {
            e.printStackTrace();
        }
        return category;
    }

    protected PropertyItem<SimplePropertyKey> populateCountItem(NodeTypeViz type, Long count) {
        SimplePropertyKey key = new SimplePropertyKey(type.getPluralName());
        String countString = count == null ? STLConstants.K0039_NOT_AVAILABLE.getValue() : UIConstants.INTEGER.format(count);
        return new PropertyItem<SimplePropertyKey>(key, countString);
    }
}

