/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network;

import com.intel.stl.api.Utils;
import com.intel.stl.api.configuration.LinkSpeedMask;
import com.intel.stl.api.configuration.LinkWidthMask;
import com.intel.stl.api.subnet.ISubnetApi;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.api.subnet.PortRecordBean;
import com.intel.stl.api.subnet.SubnetDataNotFoundException;
import com.intel.stl.ui.common.ICancelIndicator;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.model.GraphNode;
import com.intel.stl.ui.model.NodeTypeViz;
import com.intel.stl.ui.model.PropertyItem;
import com.intel.stl.ui.model.PropertySet;
import com.intel.stl.ui.model.SimplePropertyCategory;
import com.intel.stl.ui.model.SimplePropertyGroup;
import com.intel.stl.ui.model.SimplePropertyKey;
import com.intel.stl.ui.network.TopGraph;
import com.intel.stl.ui.network.TopologyTier;
import com.intel.stl.ui.network.TopologyTreeModel;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import java.awt.Point;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologySummaryProcessor {
    private final Logger log = LoggerFactory.getLogger(TopologySummaryProcessor.class);
    private final String subnetSumName;
    private final String topSumName;
    private final ISubnetApi subnetApi;
    private final TopologyTreeModel topArch;
    private final TopGraph refGraph;
    private final TopGraph graph;
    private final ICancelIndicator cancelIndicator;

    public TopologySummaryProcessor(String subnetSumName, String topSumName, TopologyTreeModel topArch, TopGraph graph, TopGraph fullGraph, ISubnetApi subnetApi, ICancelIndicator cancelIndicator) {
        this.subnetSumName = subnetSumName;
        this.topSumName = topSumName;
        this.topArch = topArch;
        this.subnetApi = subnetApi;
        this.graph = graph;
        this.refGraph = fullGraph;
        this.cancelIndicator = cancelIndicator;
    }

    public PropertySet<SimplePropertyGroup> populate() {
        Object[] allVertices;
        PropertySet<SimplePropertyGroup> model = new PropertySet<SimplePropertyGroup>();
        TopologyTier[] tiers = this.createTiers();
        SimplePropertyGroup topGroup = new SimplePropertyGroup(this.topSumName);
        for (TopologyTier tier : tiers) {
            if (this.cancelIndicator.isCancelled()) continue;
            SimplePropertyCategory category = new SimplePropertyCategory(tier.getName(), null);
            SimplePropertyKey key = new SimplePropertyKey(tier.getName());
            PropertyItem<SimplePropertyKey> item = new PropertyItem<SimplePropertyKey>(key, tier);
            category.addItem(item);
            topGroup.addPropertyCategory(category);
        }
        int numSwitches = 0;
        int numHFIs = 0;
        int numActiveSwitchPorts = 0;
        int numOtherPorts = 0;
        for (Object vertex : allVertices = this.graph.getVertices()) {
            String id = ((mxCell)vertex).getId();
            mxCell refCell = (mxCell)((mxGraphModel)this.refGraph.getModel()).getCell(id);
            GraphNode refNode = (GraphNode)refCell.getValue();
            if (refNode.getType() == NodeType.SWITCH.getId()) {
                ++numSwitches;
                int activePorts = refNode.getActivePorts();
                numActiveSwitchPorts += activePorts + 1;
                numOtherPorts += refNode.getNumPorts() - activePorts;
                continue;
            }
            if (refNode.getType() != NodeType.HFI.getId()) continue;
            ++numHFIs;
        }
        SimplePropertyGroup subnetGroup = new SimplePropertyGroup(this.subnetSumName);
        SimplePropertyCategory category = this.populateNodes(numSwitches, numHFIs);
        subnetGroup.addPropertyCategory(category);
        category = this.populateActivePorts(numActiveSwitchPorts, numHFIs);
        subnetGroup.addPropertyCategory(category);
        category = this.populateOtherPorts(numOtherPorts);
        subnetGroup.addPropertyCategory(category);
        model.addPropertyGroup(subnetGroup);
        if (numSwitches > 0) {
            model.addPropertyGroup(topGroup);
        }
        return model;
    }

    protected TopologyTier[] createTiers() {
        Map<Point, PortRecordBean> portMap = this.getPortMap();
        List<List<Integer>> ranks = this.topArch.getRanks();
        TopologyTier[] tiers = new TopologyTier[ranks.size()];
        for (int i = 0; i < tiers.length; ++i) {
            tiers[i] = new TopologyTier(i);
            List<Integer> lids = ranks.get(i);
            tiers[i].setNumSwitches(lids.size());
            int numHFIs = 0;
            int totalPorts = 0;
            TopologyTier.Quality upQuality = new TopologyTier.Quality();
            TopologyTier.Quality downQuality = new TopologyTier.Quality();
            for (int lid : lids) {
                if (!this.cancelIndicator.isCancelled()) {
                    Set<Integer> ports;
                    GraphNode node = (GraphNode)this.refGraph.getVertex(lid).getValue();
                    totalPorts += node.getNumPorts();
                    Set<GraphNode> neighbors = node.getMiddleNeighbor();
                    for (GraphNode nbr : neighbors) {
                        ports = node.getLinkPorts(nbr).keySet();
                        TopologyTier.Quality quality = null;
                        if (node.getDepth() > nbr.getDepth()) {
                            quality = downQuality;
                        } else if (node.getDepth() < nbr.getDepth()) {
                            quality = upQuality;
                        } else {
                            this.log.warn("Mismatched nodes depth " + node + " " + nbr);
                            continue;
                        }
                        this.updateQuality(quality, node.getLid(), ports, portMap);
                    }
                    neighbors = node.getEndNeighbor();
                    for (GraphNode nbr : neighbors) {
                        ports = node.getLinkPorts(nbr).keySet();
                        this.updateQuality(downQuality, node.getLid(), ports, portMap);
                    }
                    numHFIs += neighbors.size();
                }
                tiers[i].setNumHFIs(numHFIs);
                tiers[i].setUpQuality(upQuality);
                tiers[i].setDownQuality(downQuality);
                tiers[i].setNumOtherPorts(totalPorts - upQuality.getTotalPorts() - downQuality.getTotalPorts());
            }
        }
        return tiers;
    }

    protected void updateQuality(TopologyTier.Quality quality, int lid, Set<Integer> ports, Map<Point, PortRecordBean> portMap) {
        quality.increaseTotalPorts(ports.size());
        for (Integer portNum : ports) {
            PortRecordBean port = portMap.get(new Point(lid, portNum));
            if (port != null) {
                if (!Utils.isExpectedSpeed(port.getPortInfo(), LinkSpeedMask.STL_LINK_SPEED_25G)) {
                    quality.addSlowPort(lid, portNum);
                }
                if (Utils.isExpectedWidthDowngrade(port.getPortInfo(), LinkWidthMask.STL_LINK_WIDTH_4X)) continue;
                quality.addDegPort(lid, portNum);
                continue;
            }
            this.log.error("Couldn't find port lid=" + lid + " portNim=" + portNum);
        }
    }

    protected Map<Point, PortRecordBean> getPortMap() {
        HashMap<Point, PortRecordBean> map = new HashMap<Point, PortRecordBean>();
        try {
            List<PortRecordBean> ports = this.subnetApi.getPorts();
            for (PortRecordBean port : ports) {
                map.put(new Point(port.getEndPortLID(), port.getPortNum()), port);
            }
        }
        catch (SubnetDataNotFoundException e) {
            this.log.error("Couldn't create port map", (Throwable)e);
        }
        return map;
    }

    protected SimplePropertyCategory populateNodes(int numSwitches, int numHFIs) {
        SimplePropertyCategory category = new SimplePropertyCategory(STLConstants.K0014_ACTIVE_NODES.getValue(), null);
        category.setShowHeader(true);
        NodeTypeViz type = NodeTypeViz.SWITCH;
        PropertyItem<SimplePropertyKey> item = this.populateCountItem(type, numSwitches);
        category.addItem(item);
        type = NodeTypeViz.HFI;
        item = this.populateCountItem(type, numHFIs);
        category.addItem(item);
        return category;
    }

    protected SimplePropertyCategory populateActivePorts(int numSwitches, int numHFIs) {
        SimplePropertyCategory category = new SimplePropertyCategory(STLConstants.K0024_ACTIVE_PORTS.getValue(), null);
        category.setShowHeader(true);
        NodeTypeViz type = NodeTypeViz.SWITCH;
        PropertyItem<SimplePropertyKey> item = this.populateCountItem(type, numSwitches);
        category.addItem(item);
        type = NodeTypeViz.HFI;
        item = this.populateCountItem(type, numHFIs);
        category.addItem(item);
        return category;
    }

    protected SimplePropertyCategory populateOtherPorts(int others) {
        String countString = UIConstants.INTEGER.format(others);
        SimplePropertyCategory category = new SimplePropertyCategory(STLConstants.K2071_OTHER_PORTS.getValue(), countString);
        category.setShowHeader(true);
        return category;
    }

    protected PropertyItem<SimplePropertyKey> populateCountItem(NodeTypeViz type, Integer count) {
        SimplePropertyKey key = new SimplePropertyKey(type.getPluralName());
        String countString = count == null ? STLConstants.K0039_NOT_AVAILABLE.getValue() : UIConstants.INTEGER.format(count);
        return new PropertyItem<SimplePropertyKey>(key, countString);
    }
}

