/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network;

import com.intel.stl.ui.common.UILabels;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TopologyTier {
    private final String name;
    private final int index;
    private int numSwitches;
    private int numHFIs;
    private int numOtherPorts;
    private Quality upQuality;
    private Quality downQuality;

    public TopologyTier(int index) {
        this.index = index;
        this.name = UILabels.STL10212_TIRE_N.getDescription(index);
    }

    public int getNumSwitches() {
        return this.numSwitches;
    }

    public void setNumSwitches(int nodes) {
        this.numSwitches = nodes;
    }

    public int getNumHFIs() {
        return this.numHFIs;
    }

    public void setNumHFIs(int numHFIs) {
        this.numHFIs = numHFIs;
    }

    public int getNumOtherPorts() {
        return this.numOtherPorts;
    }

    public void setNumOtherPorts(int otherPorts) {
        this.numOtherPorts = otherPorts;
    }

    public int getTotalPorts() {
        return this.upQuality.getTotalPorts() + this.downQuality.getTotalPorts() + this.numOtherPorts;
    }

    public int getTotalActivePorts() {
        return this.upQuality.getTotalPorts() + this.downQuality.getTotalPorts();
    }

    public Quality getUpQuality() {
        return this.upQuality;
    }

    public void setUpQuality(Quality upQuality) {
        this.upQuality = upQuality;
    }

    public Quality getDownQuality() {
        return this.downQuality;
    }

    public void setDownQuality(Quality downQuality) {
        this.downQuality = downQuality;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return "TopologyTier [name=" + this.name + ", index=" + this.index + ", nodes=" + this.numSwitches + ", upQuality=" + this.upQuality + ", downQuality=" + this.downQuality + ", otherPorts=" + this.numOtherPorts + "]";
    }

    public static class Quality {
        private int totalPorts;
        private final List<Point> slowPorts = new ArrayList<Point>();
        private final List<Point> degPorts = new ArrayList<Point>();
        private int[] qualities;

        public int getTotalPorts() {
            return this.totalPorts;
        }

        public void setTotalPorts(int totalPorts) {
            this.totalPorts = totalPorts;
        }

        public void increaseTotalPorts(int num) {
            this.totalPorts += num;
        }

        public int getNumSlowPorts() {
            return this.slowPorts.size();
        }

        public List<Point> getSlowPorts() {
            return this.slowPorts;
        }

        public void addSlowPort(int lid, int portNum) {
            this.slowPorts.add(new Point(lid, portNum));
        }

        public int getNumDegPorts() {
            return this.degPorts.size();
        }

        public List<Point> getDegPorts() {
            return this.degPorts;
        }

        public void addDegPort(int lid, int portNum) {
            this.degPorts.add(new Point(lid, portNum));
        }

        public int[] getQualities() {
            return this.qualities;
        }

        public void setQualities(int[] qualities) {
            this.qualities = qualities;
        }

        public String toString() {
            return "Quality [totalPorts=" + this.totalPorts + ", slowPorts=" + this.slowPorts + ", degPorts=" + this.degPorts + ", qualities=" + Arrays.toString(this.qualities) + "]";
        }
    }
}

