/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network;

import com.intel.stl.ui.monitor.TreeNodeType;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

public class TopologyTreeSelectionModel
extends DefaultTreeSelectionModel {
    private static final long serialVersionUID = 8288776306386190352L;
    private final Set<TreePath> switchZeroPorts = new HashSet<TreePath>();

    @Override
    public void setSelectionPaths(TreePath[] pPaths) {
        if (pPaths.length <= 0) {
            return;
        }
        if (pPaths[0] != null) {
            int len = pPaths[0].getPathCount();
            super.setSelectionPaths(this.filterPaths(pPaths, len, false));
        }
    }

    @Override
    public void addSelectionPaths(TreePath[] paths) {
        if (this.selection != null && this.selection.length > 0) {
            int len = this.selection[0].getPathCount();
            super.addSelectionPaths(this.filterPaths(paths, len, true));
        } else {
            super.addSelectionPaths(paths);
        }
    }

    protected TreePath[] filterPaths(TreePath[] paths, int len, boolean addMode) {
        ArrayList<TreePath> validPaths = new ArrayList<TreePath>();
        ArrayList<Integer> currentSwitchZeroPorts = new ArrayList<Integer>();
        for (TreePath path : paths) {
            if (path == null) continue;
            FVResourceNode node = (FVResourceNode)path.getLastPathComponent();
            if (path.getPathCount() != len || node.getType() == TreeNodeType.INACTIVE_PORT) continue;
            validPaths.add(path);
            if (!this.isSwitchZeroPort(node)) continue;
            currentSwitchZeroPorts.add(validPaths.size() - 1);
        }
        int totalSelections = validPaths.size();
        int totalSwitchZeroPorts = currentSwitchZeroPorts.size();
        if (addMode) {
            totalSelections += this.selection == null ? 0 : this.selection.length;
            totalSwitchZeroPorts += this.switchZeroPorts.size();
        }
        if (totalSwitchZeroPorts != totalSelections) {
            for (int i = currentSwitchZeroPorts.size() - 1; i >= 0; --i) {
                int index = (Integer)currentSwitchZeroPorts.get(i);
                validPaths.remove(index);
            }
            if (addMode) {
                this.removeSelectionPaths(this.switchZeroPorts.toArray(new TreePath[0]));
            }
            this.switchZeroPorts.clear();
        } else if (!currentSwitchZeroPorts.isEmpty()) {
            if (!addMode) {
                this.switchZeroPorts.clear();
            }
            Iterator i$ = currentSwitchZeroPorts.iterator();
            while (i$.hasNext()) {
                int index = (Integer)i$.next();
                this.switchZeroPorts.add((TreePath)validPaths.get(index));
            }
        }
        return validPaths.toArray(new TreePath[0]);
    }

    protected boolean isSwitchZeroPort(FVResourceNode node) {
        return node.getId() == 0 && node.getParent() != null && node.getParent().getType() == TreeNodeType.SWITCH;
    }
}

