/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network.task;

import com.intel.stl.ui.common.ICancelIndicator;
import com.intel.stl.ui.model.LayoutType;
import com.intel.stl.ui.network.IModelChange;
import com.intel.stl.ui.network.LayoutChange;
import com.intel.stl.ui.network.TopGraph;
import com.intel.stl.ui.network.TopologyGraphController;
import com.intel.stl.ui.network.task.TopologyUpdateTask;

public class LayoutTask
extends TopologyUpdateTask {
    private final LayoutType type;
    private final IModelChange preChange;

    public LayoutTask(TopologyGraphController controller, LayoutType type, IModelChange preChange) {
        super(controller, null, null);
        this.type = type;
        this.preChange = preChange;
    }

    @Override
    public TopGraph createNewGraph(ICancelIndicator indicator, TopGraph oldGraph) {
        return this.graphView.getGraph();
    }

    @Override
    public boolean applyChanges(ICancelIndicator indicator, TopGraph newGraph) {
        if (this.preChange != null) {
            this.preChange.execute(newGraph, indicator);
        }
        LayoutChange change = new LayoutChange(this.type, this.controller.getTopTreeModel());
        change.execute(newGraph, indicator);
        return true;
    }

    @Override
    public void onSuccess(ICancelIndicator indicator, TopGraph newGraph) {
        super.onSuccess(indicator, newGraph);
        this.graphView.enableUndo(false);
        this.graphView.enableRedo(false);
        this.graphView.setLayoutType(this.type);
        this.controller.setCurrentLayout(this.type);
    }
}

