/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network.task;

import com.intel.stl.api.subnet.ISubnetApi;
import com.intel.stl.api.subnet.LinkRecordBean;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.ui.common.ICancelIndicator;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.model.LayoutType;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.network.GraphBuilder;
import com.intel.stl.ui.network.LayoutChange;
import com.intel.stl.ui.network.TopGraph;
import com.intel.stl.ui.network.TopologyGraphController;
import com.intel.stl.ui.network.TopologyTreeModel;
import com.intel.stl.ui.network.task.TopologyUpdateTask;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshGraphTask
extends TopologyUpdateTask {
    private static Logger log = LoggerFactory.getLogger(RefreshGraphTask.class);
    private final LayoutType type;
    private final IProgressObserver observer;
    private TopologyTreeModel tmpTreeMode;

    public RefreshGraphTask(TopologyGraphController controller, Object source, FVResourceNode[] selectedResources, LayoutType type, IProgressObserver observer) {
        super(controller, source, selectedResources);
        this.type = type;
        this.observer = observer;
    }

    @Override
    public TopGraph createNewGraph(ICancelIndicator indicator, TopGraph oldGraph) {
        if (indicator.isCancelled()) {
            return null;
        }
        try {
            ISubnetApi subnetApi = this.controller.getSubnetApi();
            List<NodeRecordBean> nodes = subnetApi.getNodes(false);
            List<LinkRecordBean> links = subnetApi.getLinks(false);
            TopGraph fullGraph = TopGraph.createGraph();
            GraphBuilder builder = new GraphBuilder();
            this.tmpTreeMode = builder.build(fullGraph, nodes, links);
            fullGraph.expandAll();
            return fullGraph;
        }
        catch (Exception e) {
            if (!this.isInterruptedException(e)) {
                log.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            return oldGraph;
        }
    }

    protected boolean isInterruptedException(Exception e) {
        for (Throwable tmp = e; tmp != null; tmp = tmp.getCause()) {
            if (!(tmp instanceof InterruptedException)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean applyChanges(ICancelIndicator indicator, TopGraph newGraph) {
        LayoutChange change = new LayoutChange(this.type, this.tmpTreeMode);
        change.execute(newGraph, indicator);
        return true;
    }

    @Override
    public void onSuccess(ICancelIndicator indicator, TopGraph graph) {
        final TopGraph outlineGraph = TopGraph.createGraph();
        outlineGraph.setModel(graph.getModel());
        super.onSuccess(indicator, graph);
        this.controller.setFullTopTreeModel(this.tmpTreeMode);
        this.controller.setTopTreeModel(this.tmpTreeMode);
        this.submitGraphTask(new Runnable(){

            @Override
            public void run() {
                RefreshGraphTask.this.graphView.updateGraph();
            }
        });
        this.submitOutlineTask(new Runnable(){

            @Override
            public void run() {
                RefreshGraphTask.this.guideView.setGraph(outlineGraph);
                RefreshGraphTask.this.guideView.updateGraph();
            }
        });
    }

    @Override
    public void onFinally(ICancelIndicator indicator) {
        if (this.observer != null) {
            this.observer.onFinish();
        }
    }
}

