/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network.task;

import com.intel.stl.ui.common.ICancelIndicator;
import com.intel.stl.ui.model.LayoutType;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.network.LayoutChange;
import com.intel.stl.ui.network.TopGraph;
import com.intel.stl.ui.network.TopologyGraphController;
import com.intel.stl.ui.network.TopologyTreeModel;
import com.intel.stl.ui.network.task.TopologyUpdateTask;
import javax.swing.ImageIcon;

public class ShowAllTask
extends TopologyUpdateTask {
    private TopologyTreeModel tmpTreeMode;
    private final LayoutType defaultLayout = LayoutType.TREE_SLASH;

    public ShowAllTask(TopologyGraphController controller, Object source, FVResourceNode[] selectedResources) {
        super(controller, source, selectedResources);
    }

    @Override
    public void preBackgroundTask(ICancelIndicator indicator, TopGraph oldGraph) {
        String name = this.selectedResources[0].getName();
        ImageIcon icon = this.selectedResources[0].getType().getIcon();
        this.resourceController.showAll(this.selectedResources, name, icon, this.controller.getFullTopTreeModel(), oldGraph);
    }

    @Override
    public boolean applyChanges(ICancelIndicator indicator, TopGraph newGraph) {
        this.tmpTreeMode = this.controller.getFullTopTreeModel();
        LayoutChange change = new LayoutChange(this.defaultLayout, this.tmpTreeMode);
        change.execute(newGraph, indicator);
        return true;
    }

    @Override
    public void onSuccess(final ICancelIndicator indicator, TopGraph newGraph) {
        super.onSuccess(indicator, newGraph);
        this.controller.setTopTreeModel(this.tmpTreeMode);
        if (!indicator.isCancelled() && this.source != this.controller) {
            this.controller.clearTreeSelection();
        }
        this.submitGraphTask(new Runnable(){

            @Override
            public void run() {
                ShowAllTask.this.graphView.clearEdges();
                if (!indicator.isCancelled()) {
                    ShowAllTask.this.graphView.clearSelection();
                }
                ShowAllTask.this.graphView.updateGraph();
            }
        });
        this.submitOutlineTask(new Runnable(){

            @Override
            public void run() {
                ShowAllTask.this.guideView.clearEdges();
                if (!indicator.isCancelled()) {
                    ShowAllTask.this.guideView.clearSelection();
                }
                ShowAllTask.this.guideView.updateGraph();
            }
        });
        this.guideView.setSelectedResources(this.selectedResources);
        this.setLayout(this.defaultLayout);
    }
}

