/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.view.ButtonPopup;
import com.intel.stl.ui.common.view.ISectionListener;
import com.intel.stl.ui.common.view.IntelTabbedPaneUI;
import com.intel.stl.ui.common.view.JSectionView;
import com.intel.stl.ui.main.view.IPageListener;
import com.intel.stl.ui.network.ResourceLinkPage;
import com.intel.stl.ui.network.view.ResourceLinkTabView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.swingx.JXList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceLinkSubpageView
extends JSectionView<ISectionListener>
implements ChangeListener {
    private static final long serialVersionUID = -8162278424319448619L;
    private static Logger log = LoggerFactory.getLogger(ResourceLinkSubpageView.class);
    private static final int MAX_TABS = 5;
    private JTabbedPane tabbedPane;
    private IntelTabbedPaneUI tabUI;
    private JButton moreBtn;
    private PopupPanel popupPanel;
    private ButtonPopup popup;
    private IPageListener listener;
    private String currentTab;

    public ResourceLinkSubpageView(String title, Icon icon) {
        super(title, icon);
        this.getMainComponent();
    }

    @Override
    protected JComponent getMainComponent() {
        if (this.tabbedPane != null) {
            return this.tabbedPane;
        }
        this.tabbedPane = new JTabbedPane();
        this.tabUI = new IntelTabbedPaneUI();
        this.tabbedPane.setUI(this.tabUI);
        this.tabUI.setFont(UIConstants.H4_FONT);
        this.tabUI.setTabAreaInsets(new Insets(2, 5, 4, 5));
        JPanel ctrPanel = this.tabUI.getControlPanel();
        this.installMoreButton(ctrPanel);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Runnable highlightTabs = new Runnable(){

                    @Override
                    public void run() {
                        if (ResourceLinkSubpageView.this.tabbedPane.getSelectedIndex() >= 0) {
                            ResourceLinkSubpageView.this.highlightTabs();
                        }
                    }
                };
                Util.runInEDT(highlightTabs);
            }
        });
        return this.tabbedPane;
    }

    protected void installMoreButton(JPanel ctrPanel) {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        this.moreBtn = new JButton(STLConstants.K0036_MORE.getValue(), UIImages.DOWN_ICON.getImageIcon()){
            private static final long serialVersionUID = 1L;

            @Override
            public void setEnabled(boolean b) {
                super.setEnabled(b);
                this.setForeground(b ? UIConstants.INTEL_BLUE : UIConstants.INTEL_GRAY);
            }
        };
        this.moreBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ResourceLinkSubpageView.this.popup.isVisible()) {
                    ResourceLinkSubpageView.this.popup.hide();
                } else {
                    ResourceLinkSubpageView.this.popup.show();
                }
            }
        });
        toolBar.add(this.moreBtn);
        ctrPanel.add(toolBar);
        this.popupPanel = new PopupPanel();
        this.popup = new ButtonPopup(this.moreBtn, this.popupPanel){

            @Override
            public void onShow() {
            }

            @Override
            public void onHide() {
            }
        };
    }

    public String getCurrentSubpage() {
        int currentTab = this.tabbedPane.getSelectedIndex();
        if (currentTab < 0) {
            return null;
        }
        return this.tabbedPane.getTitleAt(currentTab);
    }

    public void setPageListener(IPageListener listener) {
        this.listener = listener;
        this.tabbedPane.addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.listener == null) {
            return;
        }
        String oldTab = this.currentTab;
        int index = this.tabbedPane.getSelectedIndex();
        this.currentTab = this.tabbedPane.getTitleAt(index);
        if (oldTab != null && this.currentTab != null) {
            this.listener.onPageChanged(oldTab, this.currentTab);
        }
    }

    public synchronized void setTabs(ResourceLinkPage[] subpages, String desiredSubpage) {
        this.tabbedPane.removeChangeListener(this);
        this.popupPanel.setItems(subpages);
        this.tabbedPane.removeAll();
        this.moreBtn.setEnabled(subpages.length > 5);
        for (int i = 0; i < subpages.length; ++i) {
            ResourceLinkPage page = subpages[i];
            if (i >= 5) continue;
            this.addTab(page);
        }
        if (this.popupPanel.getPage(desiredSubpage) != null) {
            this.setCurrentSubpage(desiredSubpage);
        } else if (this.tabbedPane.getTabCount() > 0) {
            this.tabbedPane.setSelectedIndex(this.tabbedPane.getTabCount() - 1);
        }
        int index = this.tabbedPane.getSelectedIndex();
        this.currentTab = this.tabbedPane.getTitleAt(index);
        this.highlightTabs();
        this.tabbedPane.addChangeListener(this);
    }

    protected void addTab(ResourceLinkPage page) {
        String title = page.getName();
        String[] nodeNames = title.split(",");
        this.tabbedPane.addTab(title, page.getIcon(), page.getView(), page.getDescription());
        this.popupPanel.addSelection(title);
        if (this.tabbedPane.getTabCount() > 5) {
            this.popupPanel.removeSelection(this.tabbedPane.getTitleAt(0));
            this.tabbedPane.remove(0);
        }
        this.tabbedPane.setSelectedIndex(this.tabbedPane.getTabCount() - 1);
        this.updateTab(title, nodeNames);
    }

    protected boolean selectTab(ResourceLinkPage page) {
        String name = page.getName();
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            String title = this.tabbedPane.getTitleAt(i);
            if (!title.equals(name)) continue;
            this.tabbedPane.setSelectedIndex(i);
            return true;
        }
        return false;
    }

    public void updateTab(String title, String[] nodeNames) {
        ResourceLinkTabView tab = new ResourceLinkTabView(nodeNames);
        String subpageTitle = this.getCurrentSubpage();
        if (subpageTitle != null) {
            boolean highlight = subpageTitle.equals(title);
            tab.setLabelProperties(highlight);
            this.tabbedPane.setTabComponentAt(this.tabbedPane.indexOfTab(title), tab);
        } else {
            log.error(STLConstants.K3046_LINK_SUBPAGE_NULL.getValue());
        }
    }

    public void highlightTabs() {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            boolean highlight = i == this.tabbedPane.getSelectedIndex();
            ResourceLinkTabView tabView = (ResourceLinkTabView)this.tabbedPane.getTabComponentAt(i);
            if (tabView == null) continue;
            tabView.setLabelProperties(highlight);
        }
    }

    public void setCurrentSubpage(String name) {
        ResourceLinkPage page = this.popupPanel.getPage(name);
        if (page != null && !this.selectTab(page)) {
            this.addTab(page);
        }
    }

    class PopupPanel
    extends JPanel
    implements ListCellRenderer {
        private static final long serialVersionUID = 2314564428422180815L;
        private DefaultListModel model;
        private JXList list;
        private int highlightedRow = -1;
        private final Set<String> selections = new HashSet<String>();

        public PopupPanel() {
            this.initComponents();
        }

        protected void initComponents() {
            this.setLayout(new BorderLayout());
            this.model = new DefaultListModel();
            this.list = new JXList((ListModel)this.model);
            this.list.setVisibleRowCount(10);
            this.list.setCellRenderer((ListCellRenderer)this);
            this.list.setRolloverEnabled(true);
            this.list.addPropertyChangeListener("swingx.rollover", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Point location = (Point)evt.getNewValue();
                    if (location != null) {
                        PopupPanel.this.highlightedRow = location.y;
                    } else {
                        PopupPanel.this.highlightedRow = -1;
                    }
                }
            });
            this.list.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    ResourceLinkSubpageView.this.popup.hide();
                    ResourceLinkPage page = (ResourceLinkPage)PopupPanel.this.list.getSelectedValue();
                    if (page != null && !ResourceLinkSubpageView.this.selectTab(page)) {
                        ResourceLinkSubpageView.this.addTab(page);
                    }
                }
            });
            JScrollPane scroll = new JScrollPane((Component)this.list);
            scroll.getViewport().getView().setBackground(UIConstants.INTEL_WHITE);
            this.add((Component)scroll, "Center");
        }

        public void setItems(ResourceLinkPage[] pages) {
            this.clear();
            for (ResourceLinkPage page : pages) {
                this.model.addElement(page);
            }
            this.list.setVisibleRowCount(Math.min(10, pages.length));
        }

        public ResourceLinkPage getPage(String name) {
            for (int i = 0; i < this.model.getSize(); ++i) {
                ResourceLinkPage page = (ResourceLinkPage)this.model.getElementAt(i);
                if (!page.getName().equals(name)) continue;
                return page;
            }
            return null;
        }

        public void addSelection(String name) {
            this.selections.add(name);
        }

        public void removeSelection(String name) {
            this.selections.remove(name);
        }

        public void clear() {
            this.model.clear();
            this.selections.clear();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ResourceLinkPage page = (ResourceLinkPage)value;
            String[] nodeNames = page.getName().split(",");
            ResourceLinkTabView view = new ResourceLinkTabView(nodeNames);
            view.setOpaque(true);
            view.setBorder(BorderFactory.createEmptyBorder(4, 4, 2, 2));
            if (index == this.highlightedRow) {
                view.setBackground(UIConstants.INTEL_DARK_GREEN);
                view.setLabelProperties(false);
            } else if (this.selections.contains(page.getName())) {
                view.setBackground(UIConstants.INTEL_BLUE);
                view.setLabelProperties(false);
            } else if (index % 2 == 0) {
                view.setBackground(UIConstants.INTEL_WHITE);
                view.setLabelProperties(true);
            }
            view.setToolTipText(page.getDescription());
            return view;
        }
    }
}

