/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network.view;

import com.intel.stl.ui.common.IBackgroundService;
import com.intel.stl.ui.common.ICancelIndicator;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.IntelComboBoxUI;
import com.intel.stl.ui.model.GraphCells;
import com.intel.stl.ui.model.LayoutType;
import com.intel.stl.ui.network.ITopologyListener;
import com.intel.stl.ui.network.TopGraph;
import com.intel.stl.ui.network.TopGraphComponent;
import com.mxgraph.model.mxCell;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxGraphView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyGraphView
extends JPanel
implements MouseWheelListener {
    private static final long serialVersionUID = -6403935305432509869L;
    private static final Logger log = LoggerFactory.getLogger(TopologyGraphView.class);
    private JPanel ctrPanel;
    private JToolBar toolbar;
    private JButton zoomInBtn;
    private JButton zoomOutBtn;
    private JButton fitWinBtn;
    private final boolean showExtraButtons = false;
    private JButton expandBtn;
    private JButton collapseBtn;
    private JButton undoBtn;
    private JButton redoBtn;
    private JButton resetBtn;
    private JLabel algorithmLabel;
    private JComboBox algorithmBox;
    private TopGraphComponent graphComp;
    private TopGraph graph;
    private ITopologyListener topListener;
    private boolean isFittingWindow = true;
    private Timer resizeTimer;
    private final Queue<Set<String>> selections = new LinkedList<Set<String>>();
    private final IBackgroundService updateService;

    public TopologyGraphView(IBackgroundService updateService) {
        super(new BorderLayout());
        this.updateService = updateService;
        this.setOpaque(false);
        this.add((Component)this.getControlPanel(), "North");
    }

    public IBackgroundService getUpdateService() {
        return this.updateService;
    }

    protected JPanel getControlPanel() {
        if (this.ctrPanel == null) {
            this.ctrPanel = new JPanel(new BorderLayout());
            this.ctrPanel.setOpaque(false);
            this.toolbar = new JToolBar();
            this.toolbar.setFloatable(false);
            this.installNavButtons(this.toolbar);
            this.ctrPanel.add((Component)this.toolbar, "West");
        }
        return this.ctrPanel;
    }

    protected JPanel createAlgorithmPanel() {
        JPanel panel = new JPanel();
        this.algorithmLabel = ComponentFactory.getH4Label(STLConstants.K1005_LAYOUT.getValue(), 0);
        panel.add(this.algorithmLabel);
        this.algorithmBox = new JComboBox();
        this.algorithmBox.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 8785729990665992593L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                LayoutType type = (LayoutType)((Object)value);
                JComponent comp = (JComponent)super.getListCellRendererComponent((JList<?>)list, type.getName(), index, isSelected, cellHasFocus);
                list.setToolTipText(type.getDescription());
                TopologyGraphView.this.algorithmBox.setToolTipText(type.getDescription());
                return comp;
            }
        });
        this.algorithmBox.setUI(new IntelComboBoxUI());
        this.algorithmBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TopologyGraphView.this.topListener != null) {
                    TopologyGraphView.this.topListener.onLayoutTypeChange(TopologyGraphView.this.algorithmBox.getSelectedIndex());
                }
            }
        });
        this.algorithmBox.setEnabled(false);
        panel.add(this.algorithmBox);
        return panel;
    }

    protected void installNavButtons(JToolBar toolbar) {
        this.zoomInBtn = new JButton(UIImages.ZOOM_IN_ICON.getImageIcon());
        this.zoomInBtn.setToolTipText(STLConstants.K1002_ZOOM_IN.getValue());
        this.zoomInBtn.setForeground(UIConstants.INTEL_DARK_GRAY);
        this.zoomInBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TopologyGraphView.this.zoomIn();
            }
        });
        this.zoomInBtn.setEnabled(false);
        toolbar.add(this.zoomInBtn);
        this.zoomOutBtn = new JButton(UIImages.ZOOM_OUT_ICON.getImageIcon());
        this.zoomOutBtn.setToolTipText(STLConstants.K1003_ZOOM_OUT.getValue());
        this.zoomOutBtn.setForeground(UIConstants.INTEL_DARK_GRAY);
        this.zoomOutBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TopologyGraphView.this.zoomOut();
            }
        });
        this.zoomOutBtn.setEnabled(false);
        toolbar.add(this.zoomOutBtn);
        this.fitWinBtn = new JButton(UIImages.FIT_WINDOW.getImageIcon());
        this.fitWinBtn.setToolTipText(STLConstants.K1004_FIT_WINDOW.getValue());
        this.fitWinBtn.setForeground(UIConstants.INTEL_DARK_GRAY);
        this.fitWinBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TopologyGraphView.this.fitViewport();
            }
        });
        this.fitWinBtn.setEnabled(false);
        toolbar.add(this.fitWinBtn);
    }

    protected void installExtraNavButtons(JToolBar toolbar) {
        this.expandBtn = new JButton(UIImages.EXPAND_ALL.getImageIcon());
        this.expandBtn.setToolTipText(STLConstants.K1019_EXPAND_ALL.getValue());
        this.expandBtn.setForeground(UIConstants.INTEL_DARK_GRAY);
        this.expandBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TopologyGraphView.this.topListener != null) {
                    TopologyGraphView.this.topListener.onExpandAll();
                }
            }
        });
        this.expandBtn.setEnabled(false);
        toolbar.add(this.expandBtn);
        this.collapseBtn = new JButton(UIImages.COLLAPSE_ALL.getImageIcon());
        this.collapseBtn.setToolTipText(STLConstants.K1020_COLLAPSE_ALL.getValue());
        this.collapseBtn.setForeground(UIConstants.INTEL_DARK_GRAY);
        this.collapseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TopologyGraphView.this.topListener != null) {
                    TopologyGraphView.this.topListener.onCollapseAll();
                }
            }
        });
        this.collapseBtn.setEnabled(false);
        toolbar.add(this.collapseBtn);
        toolbar.addSeparator();
        this.undoBtn = new JButton(UIImages.UNDO.getImageIcon());
        this.undoBtn.setToolTipText(STLConstants.K1007_UNDO.getValue());
        this.undoBtn.setForeground(UIConstants.INTEL_DARK_GRAY);
        this.undoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TopologyGraphView.this.topListener != null) {
                    TopologyGraphView.this.topListener.onUndo();
                }
            }
        });
        this.undoBtn.setEnabled(false);
        toolbar.add(this.undoBtn);
        this.redoBtn = new JButton(UIImages.REDO.getImageIcon());
        this.redoBtn.setToolTipText(STLConstants.K1008_REDO.getValue());
        this.redoBtn.setForeground(UIConstants.INTEL_DARK_GRAY);
        this.redoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TopologyGraphView.this.topListener != null) {
                    TopologyGraphView.this.topListener.onRedo();
                }
            }
        });
        this.redoBtn.setEnabled(false);
        toolbar.add(this.redoBtn);
        this.resetBtn = new JButton(UIImages.RESET.getImageIcon());
        this.resetBtn.setToolTipText(STLConstants.K1006_RESET.getValue());
        this.resetBtn.setForeground(UIConstants.INTEL_DARK_GRAY);
        this.resetBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TopologyGraphView.this.topListener != null) {
                    TopologyGraphView.this.topListener.onReset();
                }
            }
        });
        this.resetBtn.setEnabled(false);
        toolbar.add(this.resetBtn);
    }

    public void enableUndo(boolean b) {
        this.undoBtn.setEnabled(b);
    }

    public void enableRedo(boolean b) {
        this.redoBtn.setEnabled(b);
    }

    public void setTopologyListener(ITopologyListener listener) {
        this.topListener = listener;
    }

    public TopGraph getGraph() {
        return this.graph;
    }

    public void setGraph(TopGraph graph) {
        this.graph = graph;
        if (this.graphComp == null) {
            this.graphComp = this.getGraphComponent();
            this.graphComp.getViewport().setBackground(UIConstants.INTEL_WHITE);
            this.graphComp.getViewport().setOpaque(true);
            this.add((Component)((Object)this.graphComp), "Center");
            this.enableAll(true);
        } else {
            this.graphComp.setGraph(graph);
        }
    }

    public TopGraphComponent getGraphComponent() {
        if (this.graphComp != null) {
            return this.graphComp;
        }
        this.graphComp = new TopGraphComponent(this.updateService, this.graph);
        this.graphComp.setToolTips(true);
        this.graphComp.setConnectable(false);
        this.graphComp.setSelectionListener(new mxEventSource.mxIEventListener(){

            public void invoke(Object sender, mxEventObject evt) {
                Collection added = (Collection)evt.getProperty("added");
                TopologyGraphView.this.selectionChanged(added);
            }
        });
        this.graphComp.getGraphControl().addMouseWheelListener((MouseWheelListener)this);
        this.resizeTimer = new Timer(250, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TopologyGraphView.this.graphComp != null && TopologyGraphView.this.isFittingWindow && !TopologyGraphView.this.graphComp.isUserTranslated()) {
                    TopologyGraphView.this.fitViewport();
                }
            }
        });
        this.resizeTimer.setRepeats(false);
        this.graphComp.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TopologyGraphView.this.resizeTimer.restart();
            }
        });
        return this.graphComp;
    }

    public void updateGraph() {
        this.graphComp.updateGraph();
    }

    public void setLayoutType(LayoutType type) {
        if (type != null && this.algorithmBox != null && this.algorithmBox.getSelectedItem() != type) {
            this.algorithmBox.setSelectedItem((Object)type);
        }
    }

    public void showLayoutUpdating(boolean b) {
        if (this.algorithmLabel != null) {
            this.algorithmLabel.setIcon(b ? UIImages.RUNNING.getImageIcon() : null);
        }
    }

    public void setAvailableLayouts(LayoutType[] layouts) {
        if (this.algorithmBox != null) {
            DefaultComboBoxModel<LayoutType> mode = new DefaultComboBoxModel<LayoutType>(layouts);
            this.algorithmBox.setModel(mode);
        }
    }

    protected void fitViewport() {
        if (this.graphComp == null) {
            return;
        }
        this.updateService.submit(new Runnable(){

            @Override
            public void run() {
                mxGraphView view = TopologyGraphView.this.graph.getView();
                mxRectangle graphSize = view.getGraphBounds();
                TopologyGraphView.this.graphComp.zoomToRectangle(graphSize.getRectangle());
                TopologyGraphView.this.graphComp.setUserTranslated(false);
                TopologyGraphView.this.graphComp.updateGraph();
                TopologyGraphView.this.isFittingWindow = true;
            }
        });
    }

    protected void zoomIn() {
        this.graphComp.zoomIn(null);
        this.isFittingWindow = false;
    }

    protected void zoomOut() {
        this.graphComp.zoomOut(null);
        this.isFittingWindow = false;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getWheelRotation() < 0) {
            this.graphComp.zoomIn(e.getPoint());
        } else {
            this.graphComp.zoomOut(e.getPoint());
        }
        this.isFittingWindow = false;
    }

    public void initView() {
        if (this.resizeTimer != null) {
            this.resizeTimer.restart();
        }
    }

    protected void enableAll(boolean b) {
        this.zoomInBtn.setEnabled(b);
        this.zoomOutBtn.setEnabled(b);
        this.fitWinBtn.setEnabled(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selectionChanged(Collection<mxCell> removed) {
        if (this.topListener == null) {
            return;
        }
        Queue<Set<String>> queue = this.selections;
        synchronized (queue) {
            if (this.hasChanges(this.selections.peek())) {
                GraphCells currentCells = GraphCells.create(Arrays.asList(this.graph.getSelectionCells()), true);
                this.topListener.onSelectionChange(currentCells, this, null);
            } else {
                this.selections.poll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectNodes(mxCell[] cells) {
        HashSet<String> lids = new HashSet<String>();
        if (cells != null) {
            for (mxCell cell : cells) {
                lids.add(cell.getId());
            }
        }
        if (this.hasChanges(lids)) {
            Queue<Set<String>> queue = this.selections;
            synchronized (queue) {
                this.selections.add(lids);
                this.graph.setSelectionCells(cells);
                this.graph.refresh();
            }
        }
    }

    protected boolean hasChanges(Set<String> cells) {
        Object[] graphSelections = this.graph.getSelectionCells();
        if (cells == null) {
            return graphSelections.length != 0;
        }
        if (graphSelections.length != cells.size()) {
            return true;
        }
        for (int i = 0; i < graphSelections.length; ++i) {
            mxCell graphCell = (mxCell)graphSelections[i];
            if (cells.contains(graphCell.getId())) continue;
            return true;
        }
        return false;
    }

    public void selectConnections(Collection<mxCell> cells, boolean select, ICancelIndicator indicator) {
        this.graph.markConnections(cells, select, indicator);
    }

    public void selectEdges(Collection<mxCell> cells, boolean select) {
        this.graph.markEdges(cells, select);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSelection() {
        Queue<Set<String>> queue = this.selections;
        synchronized (queue) {
            this.selections.clear();
        }
        this.graph.clearSelection();
    }

    public void clearEdges() {
        this.graph.clearMarkedEdges();
        this.graph.refresh();
    }
}

