/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network.view;

import com.intel.stl.ui.common.IBackgroundService;
import com.intel.stl.ui.common.ICancelIndicator;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.IntelTaskPaneUI;
import com.intel.stl.ui.configuration.view.PropertyVizStyle;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.network.TopGraph;
import com.intel.stl.ui.network.view.TopologyOutlinePanel;
import com.mxgraph.model.mxCell;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.plaf.TaskPaneUI;

public class TopologyGuideView
extends JPanel {
    private static final long serialVersionUID = -2726807929262245620L;
    private JXTaskPane resourcesPane;
    private JPanel resourcesPanel;
    private JXTaskPane overviewPane;
    private TopologyOutlinePanel graphOutline;
    private JXHyperlink enlargeBtn;
    private JFrame popupWindow;
    private Rectangle popupBound;
    private int popupState;
    private TopologyOutlinePanel popupOutline;
    private TopGraph graph;
    private final PropertyVizStyle style;
    private final IBackgroundService updateService;
    private boolean dirtyPopup;

    public TopologyGuideView(IBackgroundService updateService) {
        super(new BorderLayout(2, 5));
        this.updateService = updateService;
        this.setBackground(UIConstants.INTEL_WHITE);
        JXTaskPane task = this.getOverviewPane();
        this.add((Component)task, "North");
        task = this.getResourcesPane();
        this.add((Component)task, "Center");
        this.style = new PropertyVizStyle(false, true);
    }

    public IBackgroundService getUpdateService() {
        return this.updateService;
    }

    protected JXTaskPane getOverviewPane() {
        if (this.overviewPane == null) {
            this.overviewPane = new JXTaskPane(STLConstants.K1060_OUTLINE.getValue());
            this.overviewPane.setUI((TaskPaneUI)new IntelTaskPaneUI());
            Container content = this.overviewPane.getContentPane();
            content.setLayout(new BorderLayout());
            this.graphOutline = new TopologyOutlinePanel(this.updateService, TopologyOutlinePanel.Fit.WIDTH);
            this.graphOutline.setBackground(UIConstants.INTEL_WHITE);
            this.graphOutline.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIConstants.INTEL_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            content.add((Component)this.graphOutline, "Center");
            this.enlargeBtn = new JXHyperlink((Action)new AbstractAction(STLConstants.K1061_ENLARGE.getValue()){
                private static final long serialVersionUID = -4493041735258083928L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TopologyGuideView.this.graph != null) {
                        TopologyGuideView.this.showOutlineWindow();
                    }
                }
            });
            this.enlargeBtn.setHorizontalAlignment(11);
            this.enlargeBtn.setUnclickedColor(UIConstants.INTEL_BLUE);
            content.add((Component)this.enlargeBtn, "South");
        }
        return this.overviewPane;
    }

    protected JXTaskPane getResourcesPane() {
        if (this.resourcesPane == null) {
            this.resourcesPane = new JXTaskPane(STLConstants.K1062_SEL_RESOURCES.getValue());
            this.resourcesPane.setUI((TaskPaneUI)new IntelTaskPaneUI());
            this.resourcesPane.setAnimated(false);
            JPanel content = (JPanel)this.resourcesPane.getContentPane();
            content.setLayout(new BorderLayout());
            this.resourcesPanel = new JPanel();
            this.resourcesPanel.setBackground(UIConstants.INTEL_WHITE);
            this.resourcesPanel.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, UIConstants.INTEL_BACKGROUND_GRAY));
            this.resourcesPanel.setLayout(new GridBagLayout());
            JScrollPane listScroller = new JScrollPane(this.resourcesPanel);
            listScroller.setBorder(null);
            content.add((Component)listScroller, "Center");
        }
        return this.resourcesPane;
    }

    protected JFrame getPopupWindow() {
        if (this.popupWindow == null) {
            this.popupWindow = new JFrame(STLConstants.K1063_TOP_OUTLINE.getValue());
            Image[] images = new Image[]{UIImages.LOGO_24.getImage(), UIImages.LOGO_32.getImage(), UIImages.LOGO_64.getImage(), UIImages.LOGO_128.getImage()};
            this.popupWindow.setIconImages(Arrays.asList(images));
            this.popupWindow.setDefaultCloseOperation(2);
            this.popupWindow.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    TopologyGuideView.this.popupBound = TopologyGuideView.this.popupWindow.getBounds();
                    TopologyGuideView.this.popupState = TopologyGuideView.this.popupWindow.getExtendedState();
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                    TopologyGuideView.this.popupBound = TopologyGuideView.this.popupWindow.getBounds();
                    TopologyGuideView.this.popupState = TopologyGuideView.this.popupWindow.getExtendedState();
                }
            });
            JPanel content = (JPanel)this.popupWindow.getContentPane();
            content.setLayout(new BorderLayout());
            content.setBackground(UIConstants.INTEL_WHITE);
            content.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.popupOutline = new TopologyOutlinePanel(this.updateService, TopologyOutlinePanel.Fit.WINDOW);
            this.popupOutline.setBackground(UIConstants.INTEL_WHITE);
            this.popupOutline.setPreferredSize(new Dimension(800, 600));
            this.popupOutline.setMinimumSize(new Dimension(400, 300));
            this.popupOutline.setToolTipText("");
            this.popupOutline.setGraph(this.graph);
            content.add((Component)this.popupOutline, "Center");
            this.popupWindow.pack();
        }
        return this.popupWindow;
    }

    public void setGraph(TopGraph graph) {
        this.graphOutline.setGraph(graph);
        if (this.popupOutline != null) {
            this.popupOutline.setGraph(graph);
            this.dirtyPopup = false;
        }
        this.graph = graph;
    }

    public void updateGraph() {
        this.graphOutline.updateImage();
        if (this.popupOutline != null) {
            if (this.popupWindow.isVisible()) {
                this.popupOutline.updateImage();
                this.dirtyPopup = false;
            } else {
                this.dirtyPopup = true;
            }
        }
    }

    public void showOutlineWindow() {
        JFrame frame = this.getPopupWindow();
        if (frame.isVisible()) {
            if (this.popupBound != null) {
                frame.setBounds(this.popupBound);
            }
            frame.setExtendedState(this.popupState);
            frame.toFront();
        } else {
            frame.setLocationRelativeTo(SwingUtilities.getRoot(this));
            frame.setVisible(true);
        }
        if (this.dirtyPopup) {
            this.popupOutline.setImage(this.graphOutline.getImage());
            this.popupOutline.updateImage();
            this.dirtyPopup = false;
        }
    }

    public void selectNodes(mxCell[] cells) {
        HashSet<String> lids = new HashSet<String>();
        if (cells != null) {
            for (mxCell cell : cells) {
                lids.add(cell.getId());
            }
        }
        if (this.hasChanges(lids)) {
            this.graph.setSelectionCells(cells);
            this.graph.refresh();
        }
    }

    protected boolean hasChanges(Set<String> cells) {
        Object[] graphSelections = this.graph.getSelectionCells();
        if (cells == null) {
            return graphSelections.length != 0;
        }
        if (graphSelections.length != cells.size()) {
            return true;
        }
        for (int i = 0; i < graphSelections.length; ++i) {
            mxCell graphCell = (mxCell)graphSelections[i];
            if (cells.contains(graphCell.getId())) continue;
            return true;
        }
        return false;
    }

    public void selectConnections(Collection<mxCell> cells, boolean select, ICancelIndicator indicator) {
        this.graph.markConnections(cells, select, indicator);
    }

    public void selectEdges(Collection<mxCell> cells, boolean select) {
        this.graph.markEdges(cells, select);
    }

    public void clearSelection() {
        this.graph.clearSelection();
    }

    public void clearEdges() {
        this.graph.clearMarkedEdges();
    }

    public void setSelectedResources(FVResourceNode[] resources) {
        this.resourcesPanel.removeAll();
        if (resources == null || resources.length == 0) {
            return;
        }
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.gridwidth = 0;
        gc.weightx = 1.0;
        gc.insets = new Insets(0, 2, 0, 2);
        for (int i = 0; i < resources.length; ++i) {
            FVResourceNode resource = resources[i];
            JLabel label = ComponentFactory.getH4Label(this.getResoureName(resource), 0);
            label.setIcon(resource.getType().getIcon());
            label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIConstants.INTEL_BORDER_GRAY));
            this.style.decorateKey(label, i);
            this.resourcesPanel.add((Component)label, gc);
        }
        gc.weighty = 1.0;
        gc.fill = 1;
        this.resourcesPanel.add(Box.createGlue(), gc);
    }

    protected String getResoureName(FVResourceNode resource) {
        if (resource == null) {
            return "";
        }
        if (resource.isPort()) {
            return resource.getParent().getName() + ":" + resource.getName();
        }
        return resource.getName();
    }

    public void initView() {
        this.graphOutline.initView();
    }
}

