/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network.view;

import com.intel.stl.ui.common.IBackgroundService;
import com.intel.stl.ui.monitor.view.TreeView;
import com.intel.stl.ui.network.TopologyTreeSelectionModel;
import com.intel.stl.ui.network.view.ResourceView;
import com.intel.stl.ui.network.view.TopologyGraphView;
import com.intel.stl.ui.network.view.TopologyGuideView;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyView
extends TreeView {
    private static final long serialVersionUID = -1174727662197941419L;
    private static final Logger log = LoggerFactory.getLogger(TopologyView.class);
    private JSplitPane spltPane;
    private JSplitPane graphSpltPane;
    private TopologyGuideView guideView;
    private TopologyGraphView graphView;
    private ResourceView resourceView;

    public TopologyView(IBackgroundService graphService, IBackgroundService outlineService) {
        super(graphService, outlineService);
    }

    @Override
    protected JTree createTree() {
        JTree tree = super.createTree();
        tree.setSelectionModel(new TopologyTreeSelectionModel());
        return tree;
    }

    @Override
    protected JComponent getMainComponent() {
        if (this.spltPane == null) {
            this.spltPane = new JSplitPane(0);
            this.spltPane.setResizeWeight(0.8);
            this.spltPane.setDividerSize(5);
            JComponent comp = this.getGraphComponent();
            this.spltPane.setTopComponent(comp);
            comp = this.getResourceView();
            this.spltPane.setBottomComponent(comp);
        }
        return this.spltPane;
    }

    protected JComponent getGraphComponent() {
        if (this.graphSpltPane == null) {
            this.graphSpltPane = new JSplitPane(1);
            this.graphSpltPane.setResizeWeight(0.1);
            this.graphSpltPane.setDividerSize(5);
            this.graphSpltPane.setOneTouchExpandable(true);
            TopologyGuideView guideView = this.getGuideView();
            this.graphSpltPane.setLeftComponent(guideView);
            TopologyGraphView graphView = this.getGraphView();
            this.graphSpltPane.setRightComponent(graphView);
        }
        return this.graphSpltPane;
    }

    public TopologyGuideView getGuideView() {
        if (this.guideView == null) {
            this.guideView = new TopologyGuideView(this.outlineService);
        }
        return this.guideView;
    }

    public TopologyGraphView getGraphView() {
        if (this.graphView == null) {
            this.graphView = new TopologyGraphView(this.graphService);
        }
        return this.graphView;
    }

    public ResourceView getResourceView() {
        if (this.resourceView == null) {
            this.resourceView = new ResourceView();
        }
        return this.resourceView;
    }

    public void initView() {
        this.getGraphView().initView();
        this.getGuideView().initView();
    }
}

