/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance;

import com.intel.stl.ui.common.ChartsCard;
import com.intel.stl.ui.common.IPinCard;
import com.intel.stl.ui.common.IPinDelegator;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.PinArgument;
import com.intel.stl.ui.common.PinDescription;
import com.intel.stl.ui.common.view.ChartsView;
import com.intel.stl.ui.common.view.IChartCreator;
import com.intel.stl.ui.common.view.OptionChartsView;
import com.intel.stl.ui.event.JumpToEvent;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.PinBoardController;
import com.intel.stl.ui.main.UndoHandler;
import com.intel.stl.ui.main.view.IDataTypeListener;
import com.intel.stl.ui.model.ChartGroup;
import com.intel.stl.ui.model.DataType;
import com.intel.stl.ui.model.DatasetDescription;
import com.intel.stl.ui.model.HistoryType;
import com.intel.stl.ui.performance.ChartArgument;
import com.intel.stl.ui.performance.IGroupController;
import com.intel.stl.ui.performance.ISource;
import com.intel.stl.ui.performance.PerformanceChartsCreator;
import com.intel.stl.ui.performance.UndoableChartHistorySelection;
import com.intel.stl.ui.performance.UndoableDataTypeSelection;
import com.intel.stl.ui.performance.item.IPerformanceItem;
import com.intel.stl.ui.performance.provider.DataProviderName;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;
import net.engio.mbassy.bus.MBassador;

public abstract class AbstractGroupController<S extends ISource>
implements IGroupController<S>,
IPinDelegator {
    private static final boolean DEBUG = false;
    protected MBassador<IAppEvent> eventBus;
    protected Context context;
    protected int maxDataPoints = 10;
    protected DataType type;
    protected HistoryType historyType;
    private boolean isSleepMode;
    protected IPerformanceItem<S>[] allItems;
    protected List<ChartsCard> cards;
    protected ChartGroup group;
    private PinDescription.PinID pinID;
    protected PinBoardController pinBoardCtr;
    protected Map<ChartArgument<S>, IPerformanceItem<S>> pinItems = new ConcurrentHashMap<ChartArgument<S>, IPerformanceItem<S>>();
    protected Map<ChartArgument<S>, ChartsCard> pinCards = new ConcurrentHashMap<ChartArgument<S>, ChartsCard>();
    protected UndoHandler undoHandler;
    protected JumpToEvent origin;

    public AbstractGroupController(MBassador<IAppEvent> eventBus, String name, IPerformanceItem<S>[] items) {
        this.allItems = items;
        this.eventBus = eventBus;
        Map<String, DatasetDescription> map = this.initDataset();
        this.cards = this.initCards(map);
        if (this.cards != null && !this.cards.isEmpty()) {
            this.group = new ChartGroup(name, (ChartsView)this.cards.get(0).getView());
            for (ChartsCard card : this.cards) {
                this.group.addMember(new ChartGroup((ChartsView)card.getView()));
            }
        }
    }

    public List<ChartsCard> getCards() {
        return this.cards;
    }

    @Override
    public void setDataProvider(DataProviderName name) {
        for (IPerformanceItem<S> item : this.allItems) {
            if (item == null) continue;
            item.setDataProvider(name);
        }
    }

    @Override
    public void setDataSources(S[] names) {
        for (IPerformanceItem<S> item : this.allItems) {
            if (item == null) continue;
            item.setSources((ISource[])names);
        }
        this.resetViews();
    }

    protected void resetViews() {
        boolean hasPin = this.getPinID() != null;
        for (IPerformanceItem<S> item : this.allItems) {
            if (item == null) continue;
            String name = item.getName();
            ChartArgument<S> arg = this.getChartArgument(item);
            ChartsView view = this.getItemView(item);
            if (this.pinCards.containsKey(arg) || this.pinBoardCtr != null && this.pinBoardCtr.contains(item.getFullName(), arg)) {
                view.enablePin(name, false);
                continue;
            }
            view.enablePin(name, hasPin);
        }
    }

    public void setType(DataType type) {
        this.type = type;
        for (IPerformanceItem<S> item : this.allItems) {
            if (item == null) continue;
            item.setType(type);
        }
    }

    @Override
    public void setDisabledDataTypes(DataType defaultType, DataType ... types) {
        if (this.group == null) {
            return;
        }
        for (ChartGroup cg : this.group.getMembers()) {
            ChartsView view = cg.getChartView();
            if (!(view instanceof OptionChartsView)) continue;
            ((OptionChartsView)view).setType(defaultType);
            ((OptionChartsView)view).setDisbaledDataTypes(types);
        }
    }

    public void setHistoryType(HistoryType type) {
        this.historyType = type;
        for (IPerformanceItem<S> item : this.allItems) {
            if (item == null) continue;
            item.setHistoryType(type, false);
        }
    }

    protected Map<String, DatasetDescription> initDataset() {
        LinkedHashMap<String, DatasetDescription> map = new LinkedHashMap<String, DatasetDescription>();
        for (IPerformanceItem<S> item : this.allItems) {
            if (item == null) continue;
            map.put(item.getName(), item.getDatasetDescription());
        }
        return map;
    }

    protected abstract List<ChartsCard> initCards(Map<String, DatasetDescription> var1);

    protected ChartsCard createCard(IPerformanceItem<S> item, Map<String, DatasetDescription> map) {
        String name = item.getName();
        ChartsView view = new ChartsView(name, this.getChartCreator());
        return this.createChartsCard(view, map, name);
    }

    protected ChartsCard createOptionCard(final IPerformanceItem<S> item, Map<String, DatasetDescription> map, boolean historyType, boolean dataType) {
        String name = item.getName();
        final OptionChartsView view = new OptionChartsView(name, this.getChartCreator());
        if (dataType) {
            view.setDataTypeListener(new IDataTypeListener<DataType>(){

                @Override
                public void onDataTypeChange(DataType oldType, DataType newType) {
                    item.setType(newType);
                    view.setType(newType);
                    UndoHandler undoHandler = AbstractGroupController.this.getUndoHandler();
                    if (undoHandler != null && !undoHandler.isInProgress()) {
                        UndoableDataTypeSelection sel = new UndoableDataTypeSelection(item, view, oldType, newType);
                        undoHandler.addUndoAction(sel);
                    }
                }
            });
        }
        ChartsCard chartsCard = this.createChartsCard(view, map, name);
        if (historyType) {
            view.setHistoryTypeListener(new IDataTypeListener<HistoryType>(){

                @Override
                public void onDataTypeChange(HistoryType oldType, HistoryType newType) {
                    item.setHistoryType(newType, false);
                    view.setHistoryType(newType);
                    UndoHandler undoHandler = AbstractGroupController.this.getUndoHandler();
                    if (undoHandler != null && !undoHandler.isInProgress()) {
                        UndoableChartHistorySelection sel = new UndoableChartHistorySelection(item, view, oldType, newType);
                        undoHandler.addUndoAction(sel);
                    }
                }
            });
        }
        return chartsCard;
    }

    protected ChartsCard createCard(IPerformanceItem<S>[] items, Map<String, DatasetDescription> map) {
        ChartsView auxView = new ChartsView("", this.getChartCreator());
        String[] names = new String[items.length];
        String name = null;
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) continue;
            names[i] = this.getItemName(items[i]);
            if (name != null) continue;
            name = names[i];
        }
        auxView.setTitle(name);
        return this.createChartsCard(auxView, map, names);
    }

    protected String getItemName(IPerformanceItem<S> item) {
        return item == null ? null : item.getName();
    }

    protected ChartsCard createChartsCard(ChartsView view, Map<String, DatasetDescription> datasets, String ... datasetNames) {
        ArrayList<DatasetDescription> lst = new ArrayList<DatasetDescription>();
        for (String name : datasetNames) {
            if (name == null) continue;
            lst.add(datasets.get(name));
        }
        ChartsCard res = new ChartsCard(view, this.eventBus, lst);
        view.enablePin(false);
        return res;
    }

    @Override
    public ChartGroup getGroup() {
        return this.group;
    }

    @Override
    public void setOrigin(JumpToEvent origin) {
        this.origin = origin;
        for (ChartsCard card : this.cards) {
            card.setOrigin(origin);
        }
    }

    @Override
    public void setContext(Context context, IProgressObserver observer) {
        this.context = context;
        if (context == null || context.getController() == null) {
            return;
        }
        this.undoHandler = context.getController().getUndoHandler();
        for (ChartsCard chartsCard : this.cards) {
            chartsCard.setUndoHandler(this.undoHandler, this.origin);
        }
        for (IPerformanceItem<S> item : this.allItems) {
            if (item == null) continue;
            item.setContext(context, null);
        }
        for (IPerformanceItem iPerformanceItem : this.pinItems.values()) {
            if (iPerformanceItem == null) continue;
            iPerformanceItem.setContext(context, null);
        }
        this.initPinBoardController(context);
        if (observer != null) {
            observer.onFinish();
        }
    }

    protected void initPinBoardController(Context context) {
        PinBoardController ctr = context.getController().getPinBoardController();
        if (this.pinBoardCtr != ctr && this.getPinID() != null) {
            if (this.pinBoardCtr != null) {
                this.pinBoardCtr.deregisterPinProvider(this.getPinID());
            } else {
                for (ChartsCard card : this.cards) {
                    ((ChartsView)card.getView()).enablePin(true);
                    card.setPinDelegator(this);
                }
            }
            this.pinBoardCtr = ctr;
            this.pinBoardCtr.registerPinProvider(this.getPinID(), this);
        }
    }

    protected UndoHandler getUndoHandler() {
        return this.undoHandler;
    }

    @Override
    public void onRefresh(IProgressObserver observer) {
        for (IPerformanceItem<S> item : this.allItems) {
            if (item != null) {
                item.onRefresh(null);
            }
            if (observer != null && observer.isCancelled()) break;
        }
        for (IPerformanceItem<S> item : this.pinItems.values()) {
            if (item != null) {
                item.onRefresh(null);
            }
            if (observer == null || !observer.isCancelled()) continue;
            break;
        }
        if (observer != null) {
            observer.onFinish();
        }
    }

    @Override
    public void setSleepMode(boolean b) {
        this.isSleepMode = b;
        IPerformanceItem<S> primary = this.getPrimaryItem();
        primary.setActive(true);
        for (IPerformanceItem<S> item : this.allItems) {
            if (item == null || item == primary) continue;
            item.setActive(!b);
        }
    }

    protected IPerformanceItem<S> getPrimaryItem() {
        return this.allItems[0];
    }

    @Override
    public boolean isSleepMode() {
        return this.isSleepMode;
    }

    public void clear() {
        for (IPerformanceItem<S> item : this.allItems) {
            item.clear();
        }
    }

    protected IPerformanceItem<S> findItem(String name) {
        for (IPerformanceItem<S> item : this.allItems) {
            if (item == null || !item.getName().equals(name)) continue;
            return item;
        }
        throw new IllegalArgumentException("Cannot find PerformanceItem '" + name + "'");
    }

    @Override
    public PinDescription.PinID getPinID() {
        return this.pinID;
    }

    public void setPinID(PinDescription.PinID pinID) {
        this.pinID = pinID;
    }

    @Override
    public void addPin(String title, PinArgument argument) {
        if (this.pinBoardCtr != null) {
            String name = argument.getProperty("Name");
            IPerformanceItem<S> item = this.findItem(name);
            ChartArgument<S> chartArg = this.getChartArgument(item);
            PinDescription pin = new PinDescription(this.getPinID(), this.getPinTitle(item), chartArg);
            this.pinBoardCtr.addPin(pin);
        }
    }

    protected abstract ChartArgument<S> getChartArgument(IPerformanceItem<S> var1);

    protected String getPinTitle(IPerformanceItem<S> item) {
        return item.getShortName();
    }

    @Override
    public IPinCard createPin(PinDescription pin) {
        if (pin.getID() != this.getPinID()) {
            throw new IllegalArgumentException("Unmatched PinID. Expect " + (Object)((Object)this.getPinID()) + ", got " + (Object)((Object)pin.getID()));
        }
        String name = pin.getArgument().getProperty("Name");
        if (name == null) {
            throw new IllegalArgumentException("No chart name in Pin " + pin);
        }
        IPerformanceItem<S> item = this.findItem(name);
        ChartsView view = this.getItemView(item);
        if (view != null) {
            view.enablePin(name, false);
            return this.createPinCard(pin, item);
        }
        throw new IllegalArgumentException("Cannot find view for pin " + pin);
    }

    protected abstract ChartsView getItemView(IPerformanceItem<S> var1);

    protected IPinCard createPinCard(final PinDescription pin, final IPerformanceItem<S> source) {
        PinArgument arg = pin.getArgument();
        final ChartArgument<?> chartArg = ChartArgument.asChartArgument(arg);
        return new IPinCard(){

            @Override
            public PinDescription getDescription() {
                return pin;
            }

            @Override
            public Component getView() {
                ChartsCard card = AbstractGroupController.this.getPinCard(chartArg, source);
                ChartsView view = (ChartsView)card.getView();
                JComponent comp = view.getContentComponent();
                Dimension size = AbstractGroupController.this.getItemView(source).getContentComponent().getSize();
                int height = pin.getHeight();
                if (height > 0) {
                    ((Component)comp).setPreferredSize(new Dimension(size.width, height));
                } else {
                    ((Component)comp).setPreferredSize(size);
                    pin.setHeight(size.height);
                }
                return comp;
            }

            @Override
            public void unpin() {
                AbstractGroupController.this.getItemView(source).enablePin(chartArg.getName(), true);
                ChartsCard pinCard = AbstractGroupController.this.pinCards.remove(chartArg);
                IPerformanceItem pinItem = AbstractGroupController.this.pinItems.remove(chartArg);
                AbstractGroupController.this.clearPin(pinCard, pinItem);
            }
        };
    }

    protected void clearPin(ChartsCard pinCard, IPerformanceItem<S> pinItem) {
        if (pinItem != null) {
            pinItem.setActive(false);
            pinItem.clear();
        }
    }

    protected ChartsCard getPinCard(ChartArgument<S> arg, IPerformanceItem<S> source) {
        ChartsCard card = this.pinCards.get(arg);
        if (card == null) {
            HistoryType historyType;
            String name = arg.getName();
            IPerformanceItem<S> pinItem = source.copy();
            if (!pinItem.isActive()) {
                pinItem.setActive(true);
            }
            if (!pinItem.getCurrentProviderName().name().equals(arg.getProvider())) {
                pinItem.setDataProvider(DataProviderName.valueOf(arg.getProvider()));
                pinItem.setSources(arg.getSources());
            } else if (!Arrays.equals(pinItem.getSources(), arg.getSources())) {
                pinItem.setSources(arg.getSources());
            }
            DataType dataType = arg.getDataType();
            if (dataType != null) {
                pinItem.setType(dataType);
            }
            if ((historyType = arg.getHistoryTpe()) != null) {
                pinItem.setHistoryType(historyType, false);
            }
            this.pinItems.put(arg, pinItem);
            ChartsView view = new ChartsView(name, this.getChartCreator());
            Map<String, DatasetDescription> dataMap = Collections.singletonMap(name, pinItem.getDatasetDescription());
            card = this.createChartsCard(view, dataMap, name);
            this.pinCards.put(arg, card);
        }
        return card;
    }

    protected IChartCreator getChartCreator() {
        return PerformanceChartsCreator.instance();
    }
}

