/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance;

import com.intel.stl.ui.common.ChartsCard;
import com.intel.stl.ui.common.PinDescription;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.WidgetName;
import com.intel.stl.ui.common.view.ChartsView;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.HelpAction;
import com.intel.stl.ui.model.DataType;
import com.intel.stl.ui.model.HistoryType;
import com.intel.stl.ui.performance.CompactGroupController;
import com.intel.stl.ui.performance.GroupSource;
import com.intel.stl.ui.performance.item.BBHistogramItem;
import com.intel.stl.ui.performance.item.BBTopNItem;
import com.intel.stl.ui.performance.item.BBTrendItem;
import com.intel.stl.ui.performance.item.BWHistogramItem;
import com.intel.stl.ui.performance.item.BWTopNItem;
import com.intel.stl.ui.performance.item.BWTrendItem;
import com.intel.stl.ui.performance.item.CGHistogramItem;
import com.intel.stl.ui.performance.item.CGTopNItem;
import com.intel.stl.ui.performance.item.CGTrendItem;
import com.intel.stl.ui.performance.item.IntegrityHistogramItem;
import com.intel.stl.ui.performance.item.IntegrityTopNItem;
import com.intel.stl.ui.performance.item.IntegrityTrendItem;
import com.intel.stl.ui.performance.item.PRTopNItem;
import com.intel.stl.ui.performance.item.PRTrendItem;
import com.intel.stl.ui.performance.item.REHistogramItem;
import com.intel.stl.ui.performance.item.RETopNItem;
import com.intel.stl.ui.performance.item.RETrendItem;
import com.intel.stl.ui.performance.item.SCHistogramItem;
import com.intel.stl.ui.performance.item.SCTopNItem;
import com.intel.stl.ui.performance.item.SCTrendItem;
import com.intel.stl.ui.performance.item.SEHistogramItem;
import com.intel.stl.ui.performance.item.SETopNItem;
import com.intel.stl.ui.performance.item.SETrendItem;
import java.util.List;
import net.engio.mbassy.bus.MBassador;

public class CompactGroupFactory {
    private static final String TOP_N_CHART = "Top";

    public static CompactGroupController createBandwidthGroup(MBassador<IAppEvent> eventBus, int topN, DataType type, HistoryType historyType, GroupSource ... sourceNames) {
        CompactGroupController res = new CompactGroupController(eventBus, STLConstants.K0041_BANDWIDTH.getValue(), new BWTrendItem(), new BWHistogramItem(), new BWTopNItem(topN), HistoryType.values());
        res.setDataSources(sourceNames);
        res.setType(type);
        res.setHistoryType(historyType);
        res.setPinID(PinDescription.PinID.SUBNET_BW);
        CompactGroupFactory.setComponentNames(res, STLConstants.K0890_BANDWIDTH.getValue());
        CompactGroupFactory.setUnitGroupHelp(res);
        return res;
    }

    public static CompactGroupController createPacketRateGroup(MBassador<IAppEvent> eventBus, int topN, DataType type, HistoryType historyType, GroupSource ... sourceNames) {
        CompactGroupController res = new CompactGroupController(eventBus, STLConstants.K0065_PACKET_RATE.getValue(), new PRTrendItem(), null, new PRTopNItem(topN), HistoryType.values());
        res.setDataSources(sourceNames);
        res.setType(type);
        res.setHistoryType(historyType);
        res.setPinID(PinDescription.PinID.SUBNET_PR);
        CompactGroupFactory.setComponentNames(res, STLConstants.K0891_PKT_RATE.getValue());
        CompactGroupFactory.setUnitGroupHelp(res);
        return res;
    }

    private static void setUnitGroupHelp(CompactGroupController group) {
        HelpAction helpAction = HelpAction.getInstance();
        group.setHelpIDs(helpAction.getUnitGroup(), helpAction.getUnitGroup());
    }

    public static CompactGroupController createCongestionGroup(MBassador<IAppEvent> eventBus, int topN, DataType type, HistoryType historyType, GroupSource ... sourceNames) {
        CompactGroupController res = new CompactGroupController(eventBus, STLConstants.K0043_CONGESTION_ERROR.getValue(), new CGTrendItem(), new CGHistogramItem(), new CGTopNItem(topN), HistoryType.values());
        res.setDataSources(sourceNames);
        res.setType(type);
        res.setHistoryType(historyType);
        res.setPinID(PinDescription.PinID.SUBNET_CG);
        CompactGroupFactory.setComponentNames(res, STLConstants.K0892_CONGESTION.getValue());
        CompactGroupFactory.setErrorGroupHelp(res);
        return res;
    }

    public static CompactGroupController createSignalIntegrityGroup(MBassador<IAppEvent> eventBus, int topN, DataType type, HistoryType historyType, GroupSource ... sourceNames) {
        CompactGroupController res = new CompactGroupController(eventBus, STLConstants.K0067_INTEGRITY_ERROR.getValue(), new IntegrityTrendItem(), new IntegrityHistogramItem(), new IntegrityTopNItem(topN), HistoryType.values());
        res.setDataSources(sourceNames);
        res.setType(type);
        res.setHistoryType(historyType);
        res.setPinID(PinDescription.PinID.SUBNET_SI);
        CompactGroupFactory.setComponentNames(res, STLConstants.K0894_INTEGRITY.getValue());
        CompactGroupFactory.setErrorGroupHelp(res);
        return res;
    }

    public static CompactGroupController createSmaCongestionGroup(MBassador<IAppEvent> eventBus, int topN, DataType type, HistoryType historyType, GroupSource ... sourceNames) {
        CompactGroupController res = new CompactGroupController(eventBus, STLConstants.K0070_SMA_CONGESTION_ERROR.getValue(), new SCTrendItem(), new SCHistogramItem(), new SCTopNItem(topN), HistoryType.values());
        res.setDataSources(sourceNames);
        res.setType(type);
        res.setHistoryType(historyType);
        res.setPinID(PinDescription.PinID.SUBNET_SC);
        CompactGroupFactory.setComponentNames(res, STLConstants.K0893_SMA_CONGESTION.getValue());
        CompactGroupFactory.setErrorGroupHelp(res);
        return res;
    }

    public static CompactGroupController createBubbleGroup(MBassador<IAppEvent> eventBus, int topN, DataType type, HistoryType historyType, GroupSource ... sourceNames) {
        CompactGroupController res = new CompactGroupController(eventBus, STLConstants.K0487_BUBBLE_ERROR.getValue(), new BBTrendItem(), new BBHistogramItem(), new BBTopNItem(topN), HistoryType.values());
        res.setDataSources(sourceNames);
        res.setType(type);
        res.setHistoryType(historyType);
        res.setPinID(PinDescription.PinID.SUBNET_BB);
        CompactGroupFactory.setComponentNames(res, STLConstants.K0895_BUBBLE.getValue());
        CompactGroupFactory.setErrorGroupHelp(res);
        return res;
    }

    public static CompactGroupController createSecurityGroup(MBassador<IAppEvent> eventBus, int topN, DataType type, HistoryType historyType, GroupSource ... sourceNames) {
        CompactGroupController res = new CompactGroupController(eventBus, STLConstants.K0072_SECURITY.getValue(), new SETrendItem(), new SEHistogramItem(), new SETopNItem(topN), HistoryType.values());
        res.setDataSources(sourceNames);
        res.setType(type);
        res.setHistoryType(historyType);
        res.setPinID(PinDescription.PinID.SUBNET_SE);
        CompactGroupFactory.setComponentNames(res, STLConstants.K0896_SECURITY.getValue());
        CompactGroupFactory.setErrorGroupHelp(res);
        return res;
    }

    public static CompactGroupController createRoutingGroup(MBassador<IAppEvent> eventBus, int topN, DataType type, HistoryType historyType, GroupSource ... sourceNames) {
        CompactGroupController res = new CompactGroupController(eventBus, STLConstants.K0074_ROUTING_ERROR.getValue(), new RETrendItem(), new REHistogramItem(), new RETopNItem(topN), HistoryType.values());
        res.setDataSources(sourceNames);
        res.setType(type);
        res.setHistoryType(historyType);
        res.setPinID(PinDescription.PinID.SUBNET_RT);
        CompactGroupFactory.setComponentNames(res, STLConstants.K0897_ROUTING.getValue());
        CompactGroupFactory.setErrorGroupHelp(res);
        return res;
    }

    private static void setComponentNames(CompactGroupController res, String sectionName) {
        List<ChartsCard> cards = res.getCards();
        for (ChartsCard card : cards) {
            String chartName = card.getCurrentChart();
            ChartsView view = (ChartsView)card.getView();
            String helpBtnName = "";
            String pinBtnName = "";
            String panelName = "";
            if (chartName.equals(STLConstants.K0078_TREND.getValue())) {
                helpBtnName = WidgetName.HP_PERF_TREND_HELP_.name();
                pinBtnName = WidgetName.HP_PERF_TREND_PIN_.name();
                panelName = WidgetName.HP_PERF_TREND_PANEL_.name();
            } else if (chartName.startsWith(TOP_N_CHART) || chartName.equals(STLConstants.K0079_HISTOGRAM.getValue())) {
                helpBtnName = WidgetName.HP_PERF_TOPN_HISTOGRAM_HELP_.name();
                pinBtnName = WidgetName.HP_PERF_TOPN_HISTOGRAM_PIN_.name();
                panelName = WidgetName.HP_PERF_TOPN_HISTOGRAM_PANEL_.name();
            }
            view.setHelpButtonName(helpBtnName + sectionName);
            view.setPinButtonName(pinBtnName + sectionName);
            view.setMainPanelName(panelName + sectionName);
        }
    }

    private static void setErrorGroupHelp(CompactGroupController group) {
        HelpAction helpAction = HelpAction.getInstance();
        group.setHelpIDs(helpAction.getErrorGroup(), helpAction.getErrorGroup());
    }
}

