/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance;

import com.intel.stl.ui.common.ChartsCard;
import com.intel.stl.ui.common.view.ChartsView;
import com.intel.stl.ui.common.view.OptionChartsView;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.model.ChartGroup;
import com.intel.stl.ui.model.DataType;
import com.intel.stl.ui.model.DatasetDescription;
import com.intel.stl.ui.model.HistoryType;
import com.intel.stl.ui.performance.BaseGroupController;
import com.intel.stl.ui.performance.GroupSource;
import com.intel.stl.ui.performance.item.AbstractPerformanceItem;
import com.intel.stl.ui.performance.item.IPerformanceItem;
import com.intel.stl.ui.performance.item.TopNItem;
import com.intel.stl.ui.performance.item.TrendItem;
import java.util.Map;
import net.engio.mbassy.bus.MBassador;

public class OptionBaseGroupController
extends BaseGroupController {
    public OptionBaseGroupController(MBassador<IAppEvent> eventBus, String name, TrendItem<GroupSource> trendItem, AbstractPerformanceItem<GroupSource> histogramItem, TopNItem topNItem, DataType[] types, HistoryType[] historyTypes) {
        super(eventBus, name, trendItem, histogramItem, topNItem);
        if (this.group != null) {
            this.installTypes(types);
            this.installTimeScopes(historyTypes);
        }
    }

    @Override
    protected ChartsCard createTrendCard(IPerformanceItem<GroupSource> item, Map<String, DatasetDescription> map) {
        return this.createOptionCard(item, map, true, true);
    }

    @Override
    protected ChartsCard createHistogramCard(IPerformanceItem<GroupSource> item, Map<String, DatasetDescription> map) {
        return this.createOptionCard(item, map, false, true);
    }

    protected void installTypes(DataType ... types) {
        ChartsView view = this.group.getChartView();
        if (view instanceof OptionChartsView) {
            ((OptionChartsView)view).setTypes(types);
        }
        for (ChartGroup member : this.group.getMembers()) {
            ChartsView mView = member.getChartView();
            if (mView == view || !(mView instanceof OptionChartsView)) continue;
            ((OptionChartsView)mView).setTypes(types);
        }
    }

    protected void installTimeScopes(HistoryType ... types) {
        ChartsView view = this.group.getChartView();
        if (view instanceof OptionChartsView) {
            ((OptionChartsView)view).setHistoryTypes(types);
        }
    }
}

