/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.IChartCreator;
import com.intel.stl.ui.model.UtilDataset;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;

public class PerformanceChartsCreator
implements IChartCreator {
    private static final PerformanceChartsCreator instance = new PerformanceChartsCreator();

    private PerformanceChartsCreator() {
    }

    public static PerformanceChartsCreator instance() {
        return instance;
    }

    @Override
    public JFreeChart createChart(String name, Dataset dataset) {
        if (STLConstants.K0871_BANDWIDTH_TREND.getValue().equals(name)) {
            return this.getBwTrendChart(dataset);
        }
        if (Util.matchPattern(UILabels.STL10200_TOPN_BANDWIDTH.getDescription(), name)) {
            return this.getBwTopNChart(dataset);
        }
        if (STLConstants.K0045_BANDWIDTH_HISTOGRAM.getValue().equals(name)) {
            return this.getBwHistogramChart(dataset);
        }
        if (STLConstants.K0872_PACKECT_RATE_TREND.getValue().equals(name)) {
            return this.getPrTrendChart(dataset);
        }
        if (Util.matchPattern(UILabels.STL10205_TOPN_PACKET_RATE.getDescription(), name)) {
            return this.getPrTopNChart(dataset);
        }
        if (STLConstants.K0874_CONGESTION_TREND.getValue().equals(name) || STLConstants.K0873_INTEGRITY_TREND.getValue().equals(name) || STLConstants.K0875_SMA_CONGESTION_TREND.getValue().equals(name) || STLConstants.K0876_BUBBLE_TREND.getValue().equals(name) || STLConstants.K0877_SECURITY_TREND.getValue().equals(name) || STLConstants.K0878_ROUTING_TREND.getValue().equals(name)) {
            return this.getErrorTrendChart(dataset);
        }
        if (Util.matchPattern(UILabels.STL10201_TOPN_CONGESTION.getDescription(), name) || Util.matchPattern(UILabels.STL10206_TOPN_SIGNAL_INTEGRITY.getDescription(), name) || Util.matchPattern(UILabels.STL10207_TOPN_SMA_CONGESTION.getDescription(), name) || Util.matchPattern(UILabels.STL10213_TOPN_BUBBLE.getDescription(), name) || Util.matchPattern(UILabels.STL10208_TOPN_SECURITY.getDescription(), name) || Util.matchPattern(UILabels.STL10209_TOPN_ROUTING.getDescription(), name)) {
            return this.getErrorTopNChart(dataset);
        }
        if (STLConstants.K0046_CONGESTION_HISTOGRAM.getValue().equals(name) || STLConstants.K0068_INTEGRITY_HISTOGRAM.getValue().equals(name) || STLConstants.K0071_SMA_CONGESTION_HISTOGRAM.getValue().equals(name) || STLConstants.K0488_BUBBLE_HISTOGRAM.getValue().equals(name) || STLConstants.K0073_SECURITY_HISTOGRAM.getValue().equals(name) || STLConstants.K0075_ROUTING_HISTOGRAM.getValue().equals(name)) {
            return this.getErrorHistogramChart(dataset);
        }
        return null;
    }

    protected JFreeChart getBwTrendChart(Dataset dataset) {
        if (dataset instanceof UtilDataset) {
            UtilDataset ud = (UtilDataset)dataset;
            JFreeChart chart = ComponentFactory.createUtilXYTrendChart(STLConstants.K0035_TIME.getValue(), STLConstants.K0040_MBPS.getValue(), (IntervalXYDataset)ud.getUtilDataset(), (XYDataset)ud.getPmaDataset(), (XYDataset)ud.getTopoDataset(), true);
            return chart;
        }
        throw new IllegalArgumentException("Unsupported dataset type " + dataset.getClass());
    }

    protected JFreeChart getBwTopNChart(Dataset dataset) {
        JFreeChart chart = ComponentFactory.createTopNBarChart(STLConstants.K0053_CAPABILITY.getValue() + " (%)", (CategoryDataset)dataset);
        return chart;
    }

    protected JFreeChart getBwHistogramChart(Dataset dataset) {
        JFreeChart chart = ComponentFactory.createXYBarChart(STLConstants.K0053_CAPABILITY.getValue(), STLConstants.K0044_NUM_PORTS.getValue(), (IntervalXYDataset)dataset, null);
        NumberAxis axis = (NumberAxis)chart.getXYPlot().getDomainAxis();
        axis.setTickUnit(new NumberTickUnit(0.2, UIConstants.PERCENTAGE));
        axis = (NumberAxis)chart.getXYPlot().getRangeAxis();
        axis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return chart;
    }

    protected JFreeChart getPrTrendChart(Dataset dataset) {
        if (dataset instanceof UtilDataset) {
            UtilDataset ud = (UtilDataset)dataset;
            JFreeChart chart = ComponentFactory.createUtilXYTrendChart(STLConstants.K0035_TIME.getValue(), STLConstants.K0066_KPPS.getValue(), (IntervalXYDataset)ud.getUtilDataset(), (XYDataset)ud.getPmaDataset(), (XYDataset)ud.getTopoDataset(), true);
            return chart;
        }
        throw new IllegalArgumentException("Unsupported dataset type " + dataset.getClass());
    }

    protected JFreeChart getPrTopNChart(Dataset dataset) {
        JFreeChart chart = ComponentFactory.createTopNBarChart(STLConstants.K0066_KPPS.getValue(), (CategoryDataset)dataset);
        return chart;
    }

    protected JFreeChart getErrorTrendChart(Dataset dataset) {
        JFreeChart chart = ComponentFactory.createXYTrendChart(STLConstants.K0035_TIME.getValue(), STLConstants.K0125_NUM_EVENTS.getValue(), (IntervalXYDataset)dataset, true);
        return chart;
    }

    protected JFreeChart getErrorTopNChart(Dataset dataset) {
        JFreeChart chart = ComponentFactory.createTopNBarChart(STLConstants.K0126_EVENT_RATE.getValue(), (CategoryDataset)dataset);
        return chart;
    }

    protected JFreeChart getErrorHistogramChart(Dataset dataset) {
        JFreeChart chart = ComponentFactory.createBarChart(STLConstants.K0127_PERCENT_OF_THRESHOLD.getValue(), STLConstants.K0044_NUM_PORTS.getValue(), (CategoryDataset)dataset);
        NumberAxis axis = (NumberAxis)chart.getCategoryPlot().getRangeAxis();
        axis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return chart;
    }
}

