/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance.item;

import com.intel.stl.api.performance.CategoryStatBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.performance.GroupSource;
import com.intel.stl.ui.performance.item.IPerformanceItem;
import com.intel.stl.ui.performance.item.TrendItem;
import com.intel.stl.ui.performance.observer.ErrorDataObserver;
import com.intel.stl.ui.performance.observer.VFErrorDataObserver;
import com.intel.stl.ui.performance.provider.CombinedGroupInfoProvider;
import com.intel.stl.ui.performance.provider.CombinedVFInfoProvider;
import com.intel.stl.ui.performance.provider.DataProviderName;

public class IntegrityTrendItem
extends TrendItem<GroupSource> {
    public IntegrityTrendItem() {
        this(100);
    }

    public IntegrityTrendItem(int maxDataPoints) {
        super(STLConstants.K0855_SHORT_INTEG_TREND.getValue(), STLConstants.K0873_INTEGRITY_TREND.getValue(), maxDataPoints);
    }

    public IntegrityTrendItem(IntegrityTrendItem item) {
        super(item);
    }

    @Override
    protected void initDataProvider() {
        CombinedGroupInfoProvider provider = new CombinedGroupInfoProvider();
        ErrorDataObserver observer = new ErrorDataObserver(this){

            @Override
            protected long getValue(CategoryStatBean error) {
                return error.getCategoryMaximums().getIntegrityErrors();
            }
        };
        this.registerDataProvider(DataProviderName.PORT_GROUP, provider, observer);
        CombinedVFInfoProvider vfProvider = new CombinedVFInfoProvider();
        VFErrorDataObserver vfObserver = new VFErrorDataObserver(this){

            @Override
            protected long getValue(CategoryStatBean error) {
                return error.getCategoryMaximums().getIntegrityErrors();
            }
        };
        this.registerDataProvider(DataProviderName.VIRTUAL_FABRIC, vfProvider, vfObserver);
    }

    @Override
    public IPerformanceItem<GroupSource> copy() {
        return new IntegrityTrendItem(this);
    }
}

