/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance.item;

import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.model.TrendSeries;
import com.intel.stl.ui.performance.PortCounterSourceName;
import com.intel.stl.ui.performance.item.TrendItem;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PortCounterFieldItem
extends TrendItem<PortCounterSourceName> {
    private static final Logger log = LoggerFactory.getLogger(PortCounterFieldItem.class);

    public PortCounterFieldItem(String shortName, String fullName, int maxDataPoints) {
        super(shortName, fullName, maxDataPoints);
    }

    public PortCounterFieldItem(String name, String shortName, String fullName, int maxDataPoints) {
        super(name, shortName, fullName, maxDataPoints);
    }

    public PortCounterFieldItem(PortCounterFieldItem item) {
        super(item);
    }

    @Override
    public String getShortName() {
        PortCounterSourceName[] sources = (PortCounterSourceName[])this.getSources();
        if (sources == null || sources.length == 0) {
            return super.getShortName();
        }
        return sources[0].getFieldName();
    }

    @Override
    protected void initDataProvider() {
    }

    protected List<TrendSeries> createTrendSeries(PortCounterSourceName[] series) {
        ArrayList<TrendSeries> res = new ArrayList<TrendSeries>();
        if (series != null) {
            for (PortCounterSourceName serie : series) {
                TrendSeries ts = new TrendSeries(serie.getPrettyName());
                res.add(ts);
            }
        }
        return res;
    }

    @Override
    public void updateTrend(final double value, final Date date, final int interval, final PortCounterSourceName name) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                TrendSeries series = PortCounterFieldItem.this.getTimeSeries(name);
                if (series != null) {
                    PortCounterFieldItem.super.updateTrend(value, date, interval, name);
                }
            }
        });
    }

    @Override
    protected synchronized TrendSeries getTimeSeries(PortCounterSourceName name) {
        for (PortCounterSourceName sn : (PortCounterSourceName[])this.sourceNames) {
            if (!sn.equals(name)) continue;
            for (int i = 0; i < this.dataset.getSeriesCount(); ++i) {
                if (!sn.getPrettyName().equals(this.dataset.getSeries(i).getKey())) continue;
                return (TrendSeries)this.dataset.getSeries(i);
            }
        }
        log.warn(this + " " + name.sourceName() + " is not registered source!");
        return null;
    }
}

