/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance.item;

import com.intel.stl.ui.model.TrendSeries;
import com.intel.stl.ui.performance.PortSourceName;
import com.intel.stl.ui.performance.item.TrendItem;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PortCountersItem
extends TrendItem<PortSourceName> {
    private static final Logger log = LoggerFactory.getLogger(PortCountersItem.class);

    public PortCountersItem(String shortName, String fullName, int maxDataPoints) {
        super(shortName, fullName, maxDataPoints);
    }

    public PortCountersItem(String name, String shortName, String fullName, int maxDataPoints) {
        super(name, shortName, fullName, maxDataPoints);
    }

    public PortCountersItem(PortCountersItem item) {
        super(item);
    }

    @Override
    protected void initDataProvider() {
    }

    protected List<TrendSeries> createTrendSeries(PortSourceName[] series) {
        ArrayList<TrendSeries> res = new ArrayList<TrendSeries>();
        if (series != null) {
            for (PortSourceName serie : series) {
                TrendSeries all = new TrendSeries(serie.getPrettyName());
                res.add(all);
            }
        }
        return res;
    }

    @Override
    protected synchronized TrendSeries getTimeSeries(PortSourceName name) {
        for (PortSourceName sn : (PortSourceName[])this.sourceNames) {
            if (!sn.equals(name)) continue;
            for (int i = 0; i < this.dataset.getSeriesCount(); ++i) {
                if (!sn.getPrettyName().equals(this.dataset.getSeries(i).getKey())) continue;
                return (TrendSeries)this.dataset.getSeries(i);
            }
        }
        log.warn(name.sourceName() + " is not registed source!");
        return null;
    }
}

