/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance.item;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.model.TrendSeries;
import com.intel.stl.ui.monitor.ChartScaleGroupManager;
import com.intel.stl.ui.performance.ISource;
import com.intel.stl.ui.performance.item.AbstractPerformanceItem;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimePeriodValue;
import org.jfree.data.time.TimePeriodValues;
import org.jfree.data.time.TimePeriodValuesCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TrendItem<S extends ISource>
extends AbstractPerformanceItem<S> {
    private static final Logger log = LoggerFactory.getLogger(TrendItem.class);
    private static final boolean DEBUG = false;
    private ChartScaleGroupManager<TimePeriodValuesCollection> scaleManager;
    protected TimePeriodValuesCollection dataset;
    protected List<TrendSeries> trendSeries;
    private final Object copyCritical = new Object();

    public TrendItem(String shortName, String fullName) {
        this(shortName, fullName, 100);
    }

    public TrendItem(String shortName, String fullName, int maxDataPoints) {
        this(STLConstants.K0078_TREND.getValue(), shortName, fullName, maxDataPoints);
    }

    public TrendItem(String name, String shortName, String fullName, int maxDataPoints) {
        super(name, shortName, fullName, maxDataPoints);
        this.initDataProvider();
        this.initDataset();
    }

    public TrendItem(TrendItem<S> item) {
        super(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void copyDataset(AbstractPerformanceItem<S> item) {
        TrendItem trendItem = (TrendItem)item;
        this.dataset = this.createTrendDataset();
        this.trendSeries = new ArrayList<TrendSeries>();
        Object object = trendItem.copyCritical;
        synchronized (object) {
            for (TrendSeries ts : trendItem.trendSeries) {
                TrendSeries copy = new TrendSeries((String)((Object)ts.getKey()));
                for (int i = 0; i < ts.getItemCount(); ++i) {
                    TimePeriodValue val = ts.getDataItem(i);
                    TimePeriodValue valClone = (TimePeriodValue)val.clone();
                    copy.add(valClone);
                }
                this.trendSeries.add(copy);
            }
        }
        for (int i = this.trendSeries.size() - 1; i >= 0; --i) {
            this.dataset.addSeries((TimePeriodValues)this.trendSeries.get(i));
        }
    }

    protected void initDataset() {
        this.dataset = this.createTrendDataset();
        if (this.dataset != null) {
            this.trendSeries = this.createTrendSeries(this.sourceNames);
            for (int i = this.trendSeries.size() - 1; i >= 0; --i) {
                this.dataset.addSeries((TimePeriodValues)this.trendSeries.get(i));
            }
        }
    }

    protected TimePeriodValuesCollection createTrendDataset() {
        return new TimePeriodValuesCollection();
    }

    protected List<TrendSeries> createTrendSeries(S[] series) {
        ArrayList<TrendSeries> res = new ArrayList<TrendSeries>();
        if (series != null) {
            for (S serie : series) {
                TrendSeries ts = new TrendSeries(serie.sourceName());
                res.add(ts);
            }
        }
        return res;
    }

    protected TrendSeries getTimeSeries(S name) {
        for (int i = 0; i < this.dataset.getSeriesCount(); ++i) {
            if (!name.sourceName().equals(this.dataset.getSeries(i).getKey())) continue;
            return (TrendSeries)this.dataset.getSeries(i);
        }
        return null;
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    protected boolean isJumpable() {
        return false;
    }

    @Override
    public void sourcesRemoved(S[] names) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                int seriesCount = TrendItem.this.dataset.getSeriesCount();
                for (int i = 0; i < seriesCount; ++i) {
                    TrendItem.this.dataset.removeSeries(0);
                }
            }
        });
    }

    @Override
    public void sourcesToAdd(S[] names) {
        Util.runInEDT(new Runnable((ISource[])names){
            final /* synthetic */ ISource[] val$names;
            {
                this.val$names = iSourceArray;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (this.val$names != null && this.val$names.length > 0) {
                    Object object = TrendItem.this.copyCritical;
                    synchronized (object) {
                        TrendItem.this.trendSeries = TrendItem.this.createTrendSeries(this.val$names);
                        for (int i = TrendItem.this.trendSeries.size() - 1; i >= 0; --i) {
                            TrendItem.this.dataset.addSeries((TimePeriodValues)TrendItem.this.trendSeries.get(i));
                        }
                    }
                }
            }
        });
    }

    public void setScaleManager(ChartScaleGroupManager<TimePeriodValuesCollection> scaleManager) {
        this.scaleManager = scaleManager;
    }

    public ChartScaleGroupManager<TimePeriodValuesCollection> getScaleManager() {
        return this.scaleManager;
    }

    public void updateTrend(double value, Date date, int interval, S name) {
        if (this.dataset == null) {
            return;
        }
        Util.runInEDT(new Runnable((ISource)name, date, interval, value){
            final /* synthetic */ ISource val$name;
            final /* synthetic */ Date val$date;
            final /* synthetic */ int val$interval;
            final /* synthetic */ double val$value;
            {
                this.val$name = iSource;
                this.val$date = date;
                this.val$interval = n;
                this.val$value = d;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = TrendItem.this.copyCritical;
                synchronized (object) {
                    TrendSeries series = TrendItem.this.getTimeSeries(this.val$name);
                    long time = this.val$date.getTime();
                    time += (long)(this.val$interval * 1000);
                    if (series != null) {
                        TrendItem.this.removeTimePeriod(series, this.val$date.getTime(), time);
                        series.add((TimePeriod)new SimpleTimePeriod(this.val$date, new Date(time)), this.val$value);
                        if (series.getItemCount() > TrendItem.this.maxDataPoints) {
                            series.delete(0, 0);
                            TrendItem.this.deleteOldSeries(series.getDataItem(0));
                        }
                        series.fireSeriesChanged();
                    } else {
                        log.warn((Object)((Object)TrendItem.this.currentProviderName) + ":" + TrendItem.this.getName() + " " + TrendItem.this.getFullName() + ": Couldn't find TimeSeries '" + this.val$name + "'");
                    }
                }
            }
        });
        if (this.scaleManager != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TrendItem.this.scaleManager.updateChartsRange();
                }
            });
        }
    }

    protected void removeTimePeriod(TrendSeries values, long startTime, long endTime) {
        int size = values.getItemCount();
        if (size == 0) {
            return;
        }
        for (int i = size - 1; i >= 0; --i) {
            TimePeriod tp = values.getTimePeriod(i);
            if (tp.getStart().getTime() < startTime || tp.getEnd().getTime() > endTime) continue;
            values.delete(i, i);
        }
    }

    private void deleteOldSeries(TimePeriodValue tpv) {
        for (int i = 0; i < this.dataset.getSeriesCount(); ++i) {
            TimePeriod tp;
            Date start = tpv.getPeriod().getStart();
            TrendSeries ts = (TrendSeries)this.dataset.getSeries(i);
            while (ts.getItemCount() > 0 && null != (tp = ts.getTimePeriod(0)) && (tp.getStart().equals(start) || tp.getStart().before(start))) {
                ts.delete(0, 0);
            }
        }
    }

    @Override
    public void clear() {
        Util.runInEDT(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = TrendItem.this.copyCritical;
                synchronized (object) {
                    if (TrendItem.this.dataset != null) {
                        for (int i = 0; i < TrendItem.this.dataset.getSeriesCount(); ++i) {
                            int itemCount = TrendItem.this.dataset.getSeries(i).getItemCount();
                            TrendItem.this.dataset.getSeries(i).delete(0, itemCount - 1);
                        }
                    }
                }
            }
        });
    }
}

