/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance.observer;

import com.intel.stl.api.performance.CategoryStatBean;
import com.intel.stl.api.performance.GroupInfoBean;
import com.intel.stl.api.performance.UtilStatsBean;
import com.intel.stl.api.performance.VFInfoBean;
import com.intel.stl.ui.model.DataType;
import com.intel.stl.ui.performance.item.IPerformanceItem;
import com.intel.stl.ui.performance.observer.IDataObserver;

public abstract class AbstractDataObserver<E, I extends IPerformanceItem<?>>
implements IDataObserver<E> {
    protected I controller;
    protected volatile DataType type;

    public AbstractDataObserver(I controller) {
        this(controller, DataType.ALL);
    }

    public AbstractDataObserver(I controller, DataType type) {
        this.controller = controller;
        this.type = type;
    }

    @Override
    public void setType(DataType type) {
        this.type = type;
    }

    @Override
    public DataType getType() {
        return this.type;
    }

    protected UtilStatsBean[] getUtilStatsBeans(GroupInfoBean bean, DataType type) {
        switch (type) {
            case INTERNAL: {
                return new UtilStatsBean[]{bean.getInternalUtilStats()};
            }
            case TRANSMIT: {
                return new UtilStatsBean[]{bean.getSendUtilStats()};
            }
            case RECEIVE: {
                return new UtilStatsBean[]{bean.getRecvUtilStats()};
            }
            case EXTERNAL: {
                return new UtilStatsBean[]{bean.getSendUtilStats(), bean.getRecvUtilStats()};
            }
            case ALL: {
                return new UtilStatsBean[]{bean.getInternalUtilStats(), bean.getSendUtilStats(), bean.getRecvUtilStats()};
            }
        }
        throw new UnsupportedOperationException("Unknown Type " + (Object)((Object)type));
    }

    protected CategoryStatBean[] getCategoryStatBeans(GroupInfoBean bean, DataType type) {
        switch (type) {
            case INTERNAL: {
                return new CategoryStatBean[]{bean.getInternalCategoryStats()};
            }
            case EXTERNAL: {
                return new CategoryStatBean[]{bean.getExternalCategoryStats()};
            }
            case ALL: {
                return new CategoryStatBean[]{bean.getInternalCategoryStats(), bean.getExternalCategoryStats()};
            }
            case TRANSMIT: 
            case RECEIVE: {
                throw new IllegalArgumentException("Unsupported Type " + (Object)((Object)type));
            }
        }
        throw new UnsupportedOperationException("Unknown Type " + (Object)((Object)type));
    }

    protected UtilStatsBean[] getUtilStatsBeans(VFInfoBean bean, DataType type) {
        switch (type) {
            case INTERNAL: 
            case ALL: {
                return new UtilStatsBean[]{bean.getInternalUtilStats()};
            }
            case TRANSMIT: 
            case RECEIVE: 
            case EXTERNAL: {
                throw new IllegalArgumentException("Unsupported Type " + (Object)((Object)type));
            }
        }
        throw new UnsupportedOperationException("Unknown Type " + (Object)((Object)type));
    }

    protected CategoryStatBean[] getCategoryStatBeans(VFInfoBean bean, DataType type) {
        switch (type) {
            case INTERNAL: 
            case ALL: {
                return new CategoryStatBean[]{bean.getInternalCategoryStats()};
            }
            case TRANSMIT: 
            case RECEIVE: 
            case EXTERNAL: {
                throw new IllegalArgumentException("Unsupported Type " + (Object)((Object)type));
            }
        }
        throw new UnsupportedOperationException("Unknown Type " + (Object)((Object)type));
    }

    @Override
    public void reset() {
    }
}

