/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance.observer;

import com.intel.stl.api.performance.VFPortCountersBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.performance.IVFPortCountersProcessor;
import com.intel.stl.ui.performance.PortCounterSourceName;
import com.intel.stl.ui.performance.item.PortCounterFieldItem;
import com.intel.stl.ui.performance.observer.AbstractDataObserver;
import com.intel.stl.ui.performance.observer.IFieldObserver;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class VFPCDataObserver
extends AbstractDataObserver<VFPortCountersBean, PortCounterFieldItem>
implements IFieldObserver {
    private final Map<String, IVFPortCountersProcessor> processorMap = new HashMap<String, IVFPortCountersProcessor>();
    private String field;

    public VFPCDataObserver(PortCounterFieldItem controller) {
        super(controller);
        this.initProcessorMap();
    }

    private void initProcessorMap() {
        this.processorMap.put(STLConstants.K0730_RX_CUMULATIVE_DATA.getValue(), new IVFPortCountersProcessor(){

            @Override
            public long getValue(VFPortCountersBean bean) {
                return bean.getPortVFRcvData();
            }
        });
        this.processorMap.put(STLConstants.K0732_TX_CUMULATIVE_DATA.getValue(), new IVFPortCountersProcessor(){

            @Override
            public long getValue(VFPortCountersBean bean) {
                return bean.getPortVFXmitData();
            }
        });
    }

    @Override
    public synchronized void processData(VFPortCountersBean bean) {
        IVFPortCountersProcessor processor;
        if (bean == null) {
            return;
        }
        PortCounterSourceName sourceName = new PortCounterSourceName(bean.getNodeLid(), bean.getPortNumber(), this.field);
        Date time = bean.getTimestampDate();
        int interval = bean.getImageInterval();
        if (this.field != null && (processor = this.processorMap.get(this.field)) != null) {
            ((PortCounterFieldItem)this.controller).updateTrend((double)processor.getValue(bean), time, interval, sourceName);
        }
    }

    @Override
    public synchronized void setFieldName(String name) {
        this.field = name;
    }
}

