/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance.provider;

import com.intel.stl.api.performance.VFPortCountersBean;
import com.intel.stl.ui.performance.PortCounterSourceName;
import com.intel.stl.ui.performance.provider.SimpleDataProvider;
import com.intel.stl.ui.publisher.ICallback;
import com.intel.stl.ui.publisher.Task;
import com.intel.stl.ui.publisher.subscriber.SubscriberType;
import com.intel.stl.ui.publisher.subscriber.VFPortCounterSubscriber;
import java.util.Collections;
import java.util.concurrent.Future;

public class VFPortCounterFieldProvider
extends SimpleDataProvider<VFPortCountersBean, PortCounterSourceName> {
    @Override
    protected VFPortCountersBean refresh(PortCounterSourceName sourceName) {
        return this.scheduler.getPerformanceApi().getVFPortCounters(sourceName.getVfName(), sourceName.getLid(), sourceName.getPortNum());
    }

    @Override
    protected Task<VFPortCountersBean> registerTask(PortCounterSourceName sourceName, ICallback<VFPortCountersBean> callback) {
        VFPortCounterSubscriber subscriber = (VFPortCounterSubscriber)this.scheduler.getSubscriber(SubscriberType.VF_PORT_COUNTER);
        return subscriber.registerVFPortCounters(sourceName.getVfName(), sourceName.getLid(), sourceName.getPortNum(), callback);
    }

    @Override
    protected void deregisterTask(Task<VFPortCountersBean> task, ICallback<VFPortCountersBean> callback) {
        VFPortCounterSubscriber subscriber = (VFPortCounterSubscriber)this.scheduler.getSubscriber(SubscriberType.VF_PORT_COUNTER);
        subscriber.deregisterVFPortCounters(task, callback);
    }

    @Override
    protected Future<Void> initHistory(PortCounterSourceName sourceName, ICallback<VFPortCountersBean[]> callback) {
        VFPortCounterSubscriber subscriber = (VFPortCounterSubscriber)this.scheduler.getSubscriber(SubscriberType.VF_PORT_COUNTER);
        return subscriber.initVFPortCountersHistory(sourceName.getVfName(), sourceName.getLid(), Collections.singletonList(sourceName.getPortNum()), this.historyType, callback);
    }
}

