/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.publisher;

import com.intel.stl.api.ITimestamped;
import com.intel.stl.api.performance.IPerformanceApi;
import com.intel.stl.api.performance.ImageIdBean;
import com.intel.stl.api.performance.ImageInfoBean;
import com.intel.stl.ui.common.ICancelIndicator;
import com.intel.stl.ui.model.HistoryType;
import com.intel.stl.ui.publisher.CancellableCall;
import com.intel.stl.ui.publisher.ICallback;
import java.util.concurrent.Future;

public abstract class HistoryQueryTask<E extends ITimestamped>
extends CancellableCall<Void> {
    private final IPerformanceApi perfApi;
    private int lastImageInterval;
    private final int refreshRate;
    private final int maxDataPoints;
    private final int lengthInSeconds;
    private final ICallback<E[]> callback;

    public HistoryQueryTask(IPerformanceApi perfApi, int imageInterval, int refreshRate, HistoryType type, ICallback<E[]> callback) {
        this.perfApi = perfApi;
        this.lastImageInterval = imageInterval;
        this.refreshRate = refreshRate;
        this.maxDataPoints = type.getMaxDataPoints(refreshRate);
        this.lengthInSeconds = type.getLengthInSeconds();
        this.callback = callback;
    }

    public void setFuture(final Future<Void> future) {
        this.setCancelIndicator(new ICancelIndicator(){

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }
        });
    }

    @Override
    public Void call(ICancelIndicator cancelIndicator) throws Exception {
        int offset;
        ITimestamped[] datapoints;
        long firstTime = -1L;
        ImageIdBean[] imageIdBeans = this.queryImageId();
        int imageIdBeanLength = imageIdBeans.length;
        long[] imageIds = new long[imageIdBeanLength];
        for (int j = 0; j < imageIdBeanLength; ++j) {
            imageIds[j] = imageIdBeans[j].getImageNumber();
        }
        double step = this.getHistoryStep(this.lastImageInterval, this.refreshRate);
        long lastTimePoint = this.queryImageTime(imageIds[0], 0);
        int lastOffset = 0;
        double tmpOffset = 0.0;
        for (int i = 0; i < this.getMaxDataPoints() && !cancelIndicator.isCancelled() && (datapoints = this.queryHistory(imageIds, offset = (int)(tmpOffset -= step))) != null && datapoints.length > 0; ++i) {
            ITimestamped datapoint = datapoints[0];
            long time = datapoint.getTimestamp();
            if (firstTime == -1L) {
                firstTime = time;
            } else if (firstTime - time > (long)this.getLengthInSeconds()) break;
            int curInterval = datapoint.getImageInterval();
            if (curInterval != this.lastImageInterval) {
                offset = this.adjustOffset(imageIds[0], lastTimePoint, lastOffset, cancelIndicator);
                datapoints = this.queryHistory(imageIds, offset);
                if (datapoints == null || datapoints.length == 0) break;
                tmpOffset = offset;
                time = datapoints[0].getTimestamp();
                this.lastImageInterval = datapoints[0].getImageInterval();
                step = this.getHistoryStep(this.lastImageInterval, this.refreshRate);
            }
            this.callback.onDone(datapoints);
            lastTimePoint = time;
            lastOffset = offset;
            Thread.yield();
        }
        return null;
    }

    protected int getMaxDataPoints() {
        return this.maxDataPoints;
    }

    protected int getLengthInSeconds() {
        return this.lengthInSeconds;
    }

    protected int adjustOffset(long imageNumber, long refTimePoint, int refOffset, ICancelIndicator cancelIndicator) {
        long desiredTime = refTimePoint - (long)this.refreshRate;
        int offset = refOffset - 1;
        long time = 0L;
        while ((time = this.queryImageTime(imageNumber, offset)) > 0L && time > desiredTime) {
            if (cancelIndicator.isCancelled()) {
                return offset;
            }
            --offset;
        }
        if (time < 0L) {
            return offset;
        }
        double delta1 = desiredTime - time;
        double delta2 = this.queryImageTime(imageNumber, offset + 1) - desiredTime;
        if (delta1 <= delta2 || offset == refOffset - 1) {
            return offset;
        }
        return offset + 1;
    }

    protected long queryImageTime(long imageNumber, int offset) {
        ImageInfoBean bean = this.perfApi.getImageInfo(imageNumber, offset);
        if (bean != null) {
            return bean.getTimestamp();
        }
        return -1L;
    }

    protected double getHistoryStep(int imageInterval, int refreshRate) {
        double step = Math.max(1.0, (double)refreshRate / (double)imageInterval);
        return step;
    }

    protected abstract ImageIdBean[] queryImageId();

    protected abstract E[] queryHistory(long[] var1, int var2);
}

