/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.publisher;

import com.intel.stl.ui.publisher.BatchedCallback;
import com.intel.stl.ui.publisher.ICallback;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;

public class Task<E> {
    private final int type;
    private final Object key;
    private final String description;
    private Callable<E> caller;
    private ScheduledFuture<?> future;
    private final List<ICallback<E>> callBacks = new LinkedList<ICallback<E>>();

    public Task(int type, Object key, String description) {
        this.type = type;
        this.key = key;
        this.description = description;
    }

    public Object getKey() {
        return this.key;
    }

    public String getDescription() {
        return this.description;
    }

    public Callable<E> getCaller() {
        return this.caller;
    }

    public void setCaller(Callable<E> callers) {
        this.caller = callers;
    }

    public ScheduledFuture<?> getFuture() {
        return this.future;
    }

    protected void setFuture(ScheduledFuture<?> future) {
        this.future = future;
    }

    protected synchronized void addCallback(ICallback<E> callBack) {
        this.callBacks.add(callBack);
    }

    protected synchronized int getCallbackPosition(ICallback<E> callBack) {
        return this.callBacks.indexOf(callBack);
    }

    protected synchronized void removeCallback(ICallback<E> callBack) {
        this.callBacks.remove(callBack);
    }

    protected synchronized void removeSubCallbacks(ICallback<E[]> callBack) {
        ICallback[] members;
        for (ICallback ck : members = this.callBacks.toArray(new ICallback[0])) {
            if (!(ck instanceof BatchedCallback.IndexedCallback) || !((BatchedCallback.IndexedCallback)ck).belongToCallback(callBack)) continue;
            this.callBacks.remove(ck);
        }
    }

    protected synchronized boolean isEmpty() {
        return this.callBacks.isEmpty();
    }

    public synchronized List<ICallback<E>> clearCallbacks() {
        ArrayList<ICallback<E>> res = new ArrayList<ICallback<E>>(this.callBacks);
        this.callBacks.clear();
        return res;
    }

    public List<ICallback<E>> getCallBacks() {
        return this.callBacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void onDone(E result) {
        for (ICallback<E> callback : this.callBacks) {
            try {
                callback.onDone(result);
            }
            catch (Exception e) {
                callback.onError(e);
            }
            finally {
                try {
                    callback.onFinally();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }
    }

    protected synchronized void onError(Exception error) {
        for (ICallback<E> callback : this.callBacks) {
            try {
                callback.onError(error);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + this.type;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Task other = (Task)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        return "Task [type=" + this.type + ", key=" + this.key + ", description=" + this.description + ",  callBacks=" + this.callBacks + "]";
    }

    protected static interface ICallbackHandler<E> {
        public void handleCallback(ICallback<E> var1);
    }
}

