/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.publisher.subscriber;

import com.intel.stl.api.subnet.DefaultDeviceGroup;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.model.StateSummary;
import com.intel.stl.ui.publisher.EventCalculator;
import com.intel.stl.ui.publisher.ICallback;
import com.intel.stl.ui.publisher.Task;
import com.intel.stl.ui.publisher.subscriber.IRegisterTask;
import com.intel.stl.ui.publisher.subscriber.Subscriber;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSubscriber
extends Subscriber<StateSummary> {
    private static Logger log = LoggerFactory.getLogger(EventSubscriber.class);
    private static int KEY = 0x10000000;
    private final EventCalculator evtCal;

    public EventSubscriber(IRegisterTask taskScheduler, EventCalculator evtCal) {
        super(taskScheduler, null);
        this.evtCal = evtCal;
    }

    public synchronized Task<StateSummary> registerStateSummary(ICallback<StateSummary> callback) {
        Task task = new Task(KEY, DefaultDeviceGroup.ALL.name(), UILabels.STL40012_DEVICE_STATES.getDescription());
        Callable<StateSummary> caller = new Callable<StateSummary>(){

            @Override
            public StateSummary call() throws Exception {
                StateSummary res = EventSubscriber.this.evtCal.getSummary();
                return res;
            }
        };
        try {
            Task<StateSummary> submittedTask = this.taskScheduler.scheduleTask(this.taskList, task, callback, caller);
            return submittedTask;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public synchronized void deregisterStateSummary(Task<StateSummary> task, ICallback<StateSummary> callback) {
        try {
            this.taskScheduler.removeTask(this.taskList, task, callback);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

