/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.publisher.subscriber;

import com.intel.stl.api.performance.FocusPortsRspBean;
import com.intel.stl.api.performance.IPerformanceApi;
import com.intel.stl.api.subnet.Selection;
import com.intel.stl.ui.publisher.FocusPortsTask;
import com.intel.stl.ui.publisher.ICallback;
import com.intel.stl.ui.publisher.Task;
import com.intel.stl.ui.publisher.subscriber.IRegisterTask;
import com.intel.stl.ui.publisher.subscriber.Subscriber;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FocusPortCounterSubscriber
extends Subscriber<List<FocusPortsRspBean>> {
    private static Logger log = LoggerFactory.getLogger(FocusPortCounterSubscriber.class);

    public FocusPortCounterSubscriber(IRegisterTask taskScheduler, IPerformanceApi perfApi) {
        super(taskScheduler, perfApi);
    }

    public synchronized Task<List<FocusPortsRspBean>> registerFocusPorts(final String group, final Selection selection, final int range, ICallback<List<FocusPortsRspBean>> callback) {
        FocusPortsTask task = new FocusPortsTask(group, selection, range);
        Callable<List<FocusPortsRspBean>> caller = new Callable<List<FocusPortsRspBean>>(){

            @Override
            public List<FocusPortsRspBean> call() throws Exception {
                List<FocusPortsRspBean> ports = FocusPortCounterSubscriber.this.perfApi.getFocusPorts(group, selection, range);
                return ports;
            }
        };
        try {
            Task<List<FocusPortsRspBean>> submittedTask = this.taskScheduler.scheduleTask(this.taskList, task, callback, caller);
            return submittedTask;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public synchronized void deregisterFocusPorts(Task<List<FocusPortsRspBean>> task, ICallback<List<FocusPortsRspBean>> callback) {
        try {
            this.taskScheduler.removeTask(this.taskList, task, callback);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

