/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.publisher.subscriber;

import com.intel.stl.api.performance.GroupInfoBean;
import com.intel.stl.api.performance.IPerformanceApi;
import com.intel.stl.api.performance.ImageIdBean;
import com.intel.stl.api.performance.PMConfigBean;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.model.HistoryType;
import com.intel.stl.ui.publisher.BatchedCallback;
import com.intel.stl.ui.publisher.HistoryQueryTask;
import com.intel.stl.ui.publisher.ICallback;
import com.intel.stl.ui.publisher.Task;
import com.intel.stl.ui.publisher.subscriber.IRegisterTask;
import com.intel.stl.ui.publisher.subscriber.Subscriber;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupInfoSubscriber
extends Subscriber<GroupInfoBean> {
    private static final boolean DUMP_DATA = false;
    private static Logger log = LoggerFactory.getLogger(GroupInfoSubscriber.class);

    public GroupInfoSubscriber(IRegisterTask taskScheduler, IPerformanceApi perfApi) {
        super(taskScheduler, perfApi);
    }

    public synchronized Task<GroupInfoBean> registerGroupInfo(final String group, ICallback<GroupInfoBean> callback) {
        Task task = new Task(161, group, UILabels.STL40008_GROUPINFO_TASK.getDescription(group));
        Callable<GroupInfoBean> caller = new Callable<GroupInfoBean>(){

            @Override
            public GroupInfoBean call() throws Exception {
                GroupInfoBean groupInfo = GroupInfoSubscriber.this.perfApi.getGroupInfo(group);
                return groupInfo;
            }
        };
        try {
            Task<GroupInfoBean> submittedTask = this.taskScheduler.scheduleTask(this.taskList, task, callback, caller);
            return submittedTask;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public synchronized void deregisterGroupInfo(Task<GroupInfoBean> task, ICallback<GroupInfoBean> callback) {
        try {
            this.taskScheduler.removeTask(this.taskList, task, callback);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized List<Task<GroupInfoBean>> registerGroupInfo(String[] groups, ICallback<GroupInfoBean[]> callback) {
        ArrayList<Task<GroupInfoBean>> tasks = new ArrayList<Task<GroupInfoBean>>();
        BatchedCallback<GroupInfoBean> bCallback = new BatchedCallback<GroupInfoBean>(groups.length, callback, GroupInfoBean.class);
        for (int i = 0; i < groups.length; ++i) {
            Task<GroupInfoBean> task = this.registerGroupInfo(groups[i], bCallback.getCallback(i));
            tasks.add(task);
        }
        return tasks;
    }

    public synchronized void deregisterGroupInfo(List<Task<GroupInfoBean>> tasks, ICallback<GroupInfoBean[]> callbacks) {
        try {
            this.taskScheduler.removeTask(this.taskList, tasks, callbacks);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public Future<Void> initGroupInfoHistory(final String[] groups, HistoryType type, ICallback<GroupInfoBean[]> callback) {
        PMConfigBean conf = this.perfApi.getPMConfig();
        int sweepInterval = conf.getSweepInterval();
        HistoryQueryTask<GroupInfoBean> historyQueryTask = new HistoryQueryTask<GroupInfoBean>(this.perfApi, sweepInterval, this.taskScheduler.getRefreshRate(), type, callback){

            protected GroupInfoBean[] queryHistory(long[] imageIDs, int offset) {
                GroupInfoBean[] res = new GroupInfoBean[groups.length];
                for (int i = 0; i < groups.length; ++i) {
                    GroupInfoBean gib = GroupInfoSubscriber.this.perfApi.getGroupInfoHistory(groups[i], imageIDs[i], offset);
                    if (gib == null) {
                        return null;
                    }
                    res[i] = gib;
                }
                return res;
            }

            @Override
            protected ImageIdBean[] queryImageId() {
                ImageIdBean[] imageIdBeans = new ImageIdBean[groups.length];
                for (int i = 0; i < groups.length; ++i) {
                    ImageIdBean imageIdBean;
                    GroupInfoBean groupInfoBean = GroupInfoSubscriber.this.perfApi.getGroupInfoHistory(groups[i], 0L, -2);
                    imageIdBeans[i] = imageIdBean = groupInfoBean.getImageId();
                }
                return imageIdBeans;
            }
        };
        return this.submitHistoryQueryTask(historyQueryTask);
    }
}

