/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.publisher.subscriber;

import com.intel.stl.api.performance.IPerformanceApi;
import com.intel.stl.api.performance.ImageInfoBean;
import com.intel.stl.api.subnet.DefaultDeviceGroup;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.publisher.ICallback;
import com.intel.stl.ui.publisher.Task;
import com.intel.stl.ui.publisher.subscriber.IRegisterTask;
import com.intel.stl.ui.publisher.subscriber.Subscriber;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageInfoSubscriber
extends Subscriber<ImageInfoBean> {
    private static Logger log = LoggerFactory.getLogger(ImageInfoSubscriber.class);

    public ImageInfoSubscriber(IRegisterTask taskScheduler, IPerformanceApi perfApi) {
        super(taskScheduler, perfApi);
    }

    public synchronized Task<ImageInfoBean> registerImageInfo(ICallback<ImageInfoBean> callback) {
        Task task = new Task(171, DefaultDeviceGroup.ALL.name(), UILabels.STL40007_IMAGEINFO_TASK.getDescription(DefaultDeviceGroup.ALL.name()));
        Callable<ImageInfoBean> caller = new Callable<ImageInfoBean>(){

            @Override
            public ImageInfoBean call() throws Exception {
                ImageInfoBean imageInfo = ImageInfoSubscriber.this.perfApi.getLatestImageInfo();
                return imageInfo;
            }
        };
        try {
            Task<ImageInfoBean> submittedTask = this.taskScheduler.scheduleTask(this.taskList, task, callback, caller);
            return submittedTask;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public synchronized void deregisterImageInfo(Task<ImageInfoBean> task, ICallback<ImageInfoBean> callback) {
        try {
            this.taskScheduler.removeTask(this.taskList, task, callback);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

