/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.publisher.subscriber;

import com.intel.stl.api.ITimestamped;
import com.intel.stl.api.performance.IPerformanceApi;
import com.intel.stl.ui.publisher.HistoryQueryTask;
import com.intel.stl.ui.publisher.ICallback;
import com.intel.stl.ui.publisher.Task;
import com.intel.stl.ui.publisher.subscriber.IRegisterTask;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;

public abstract class Subscriber<E> {
    protected List<Task<E>> taskList = new ArrayList<Task<E>>();
    protected final IRegisterTask taskScheduler;
    protected final IPerformanceApi perfApi;

    public Subscriber(IRegisterTask taskScheduler, IPerformanceApi perfApi) {
        this.taskScheduler = taskScheduler;
        this.perfApi = perfApi;
    }

    public synchronized void cancelTask(Task<E> task) {
        if (task != null) {
            task.getFuture().cancel(true);
        }
    }

    public synchronized void cancelTasks() {
        for (Task<E> task : this.taskList) {
            if (task == null) continue;
            task.getFuture().cancel(true);
        }
        this.taskList.clear();
    }

    public synchronized void rescheduleTasks() {
        ArrayList<Task<E>> newTaskList = new ArrayList<Task<E>>();
        for (Task<E> task : this.taskList) {
            if (task == null) continue;
            List<ICallback<E>> callbacks = task.clearCallbacks();
            task.getFuture().cancel(true);
            for (ICallback<E> callback : callbacks) {
                callback.reset();
                this.taskScheduler.scheduleTask(newTaskList, task, callback, task.getCaller());
            }
        }
        this.taskList = newTaskList;
    }

    protected <T extends ITimestamped> Future<Void> submitHistoryQueryTask(HistoryQueryTask<T> task) {
        Future<Void> future = this.taskScheduler.submitToBackground(task);
        task.setFuture(future);
        return future;
    }
}

