/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.publisher.subscriber;

import com.intel.stl.api.performance.IPerformanceApi;
import com.intel.stl.api.performance.ImageIdBean;
import com.intel.stl.api.performance.PMConfigBean;
import com.intel.stl.api.performance.VFInfoBean;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.model.HistoryType;
import com.intel.stl.ui.publisher.BatchedCallback;
import com.intel.stl.ui.publisher.HistoryQueryTask;
import com.intel.stl.ui.publisher.ICallback;
import com.intel.stl.ui.publisher.Task;
import com.intel.stl.ui.publisher.subscriber.IRegisterTask;
import com.intel.stl.ui.publisher.subscriber.Subscriber;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VFInfoSubscriber
extends Subscriber<VFInfoBean> {
    private static Logger log = LoggerFactory.getLogger(VFInfoSubscriber.class);

    public VFInfoSubscriber(IRegisterTask taskScheduler, IPerformanceApi perfApi) {
        super(taskScheduler, perfApi);
    }

    public synchronized Task<VFInfoBean> registerVFInfo(final String name, ICallback<VFInfoBean> callback) {
        Task task = new Task(174, name, UILabels.STL40009_VFINFO_TASK.getDescription(name));
        Callable<VFInfoBean> caller = new Callable<VFInfoBean>(){

            @Override
            public VFInfoBean call() throws Exception {
                VFInfoBean groupInfo = VFInfoSubscriber.this.perfApi.getVFInfo(name);
                return groupInfo;
            }
        };
        try {
            Task<VFInfoBean> submittedTask = this.taskScheduler.scheduleTask(this.taskList, task, callback, caller);
            return submittedTask;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public synchronized void deregisterVFInfo(Task<VFInfoBean> task, ICallback<VFInfoBean> callback) {
        try {
            this.taskScheduler.removeTask(this.taskList, task, callback);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized List<Task<VFInfoBean>> registerVFInfo(String[] names, ICallback<VFInfoBean[]> callback) {
        ArrayList<Task<VFInfoBean>> tasks = new ArrayList<Task<VFInfoBean>>();
        BatchedCallback<VFInfoBean> bCallback = new BatchedCallback<VFInfoBean>(names.length, callback, VFInfoBean.class);
        for (int i = 0; i < names.length; ++i) {
            Task<VFInfoBean> task = this.registerVFInfo(names[i], bCallback.getCallback(i));
            tasks.add(task);
        }
        return tasks;
    }

    public synchronized void deregisterVFInfo(List<Task<VFInfoBean>> tasks, ICallback<VFInfoBean[]> callbacks) {
        try {
            this.taskScheduler.removeTask(this.taskList, tasks, callbacks);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public Future<Void> initVFInfoHistory(final String[] groups, HistoryType type, ICallback<VFInfoBean[]> callback) {
        PMConfigBean conf = this.perfApi.getPMConfig();
        int sweepInterval = conf.getSweepInterval();
        HistoryQueryTask<VFInfoBean> historyQueryTask = new HistoryQueryTask<VFInfoBean>(this.perfApi, sweepInterval, this.taskScheduler.getRefreshRate(), type, callback){

            protected VFInfoBean[] queryHistory(long[] imageIDs, int offset) {
                VFInfoBean[] res = new VFInfoBean[groups.length];
                for (int i = 0; i < groups.length; ++i) {
                    VFInfoBean gib = VFInfoSubscriber.this.perfApi.getVFInfoHistory(groups[i], imageIDs[i], offset);
                    if (gib == null) {
                        return null;
                    }
                    res[i] = gib;
                }
                return res;
            }

            @Override
            protected ImageIdBean[] queryImageId() {
                ImageIdBean[] imageIdBeans = new ImageIdBean[groups.length];
                for (int i = 0; i < groups.length; ++i) {
                    ImageIdBean imageIdBean;
                    VFInfoBean vfInfoBean = VFInfoSubscriber.this.perfApi.getVFInfoHistory(groups[i], 0L, -2);
                    imageIdBeans[i] = imageIdBean = vfInfoBean.getImageId();
                }
                return imageIdBeans;
            }
        };
        return this.submitHistoryQueryTask(historyQueryTask);
    }
}

